/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.SerializableDescriptorEventHolder;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.MethodSerialImpl;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class JPAEntityListenerHolder
implements SerializableDescriptorEventHolder,
Cloneable {
    public String listenerClassName;
    public Boolean isDefaultListener;
    public transient DescriptorEventListener listener;
    public Hashtable<String, List<MethodSerialImpl>> serializableMethods;

    public void setIsDefaultListener(Boolean isDefaultListener) {
        this.isDefaultListener = isDefaultListener;
    }

    @Override
    public void addListenerToEventManager(ClassDescriptor descriptor, AbstractSession session, ClassLoader loader) {
        if (this.listener == null) {
            if (this.listenerClassName != null) {
                Class listenerClass = this.getListenerClass(loader);
                if (DescriptorEventListener.class.isAssignableFrom(listenerClass)) {
                    this.listener = (DescriptorEventListener)this.constructListenerInstance(listenerClass);
                } else {
                    EntityListener entityListener = new EntityListener(listenerClass, descriptor.getJavaClass());
                    entityListener.setOwningSession(session);
                    if (this.serializableMethods != null) {
                        entityListener.setAllEventMethods(this.convertToMethods(loader));
                    }
                    this.listener = entityListener;
                }
            } else {
                EntityClassListener entityListener = new EntityClassListener(descriptor.getJavaClass());
                entityListener.setAllEventMethods(this.convertToMethods(loader));
                this.listener = entityListener;
            }
        }
        if (this.listenerClassName != null) {
            if (this.isDefaultListener.booleanValue()) {
                descriptor.getEventManager().addDefaultEventListener(this.listener);
            } else {
                descriptor.getEventManager().addEntityListenerEventListener(this.listener);
            }
        } else {
            descriptor.getEventManager().setEntityEventListener(this.listener);
        }
    }

    protected Object constructListenerInstance(Class listenerClass) {
        Object entityListenerClassInstance;
        block6: {
            entityListenerClassInstance = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        entityListenerClassInstance = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(listenerClass));
                        break block6;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.errorInstantiatingClass(listenerClass, exception.getException());
                    }
                }
                entityListenerClassInstance = PrivilegedAccessHelper.newInstanceFromClass(listenerClass);
            }
            catch (IllegalAccessException exception) {
                throw ValidationException.errorInstantiatingClass(listenerClass, exception);
            }
            catch (InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass(listenerClass, exception);
            }
        }
        return entityListenerClassInstance;
    }

    public void convertToSerializableMethods(Hashtable<String, List<Method>> methods) {
        this.serializableMethods = new Hashtable();
        for (String event : methods.keySet()) {
            List<Method> methodList = methods.get(event);
            ArrayList<MethodSerialImpl> newMethodList = new ArrayList<MethodSerialImpl>();
            for (Method method : methodList) {
                MethodSerialImpl serializableMethod = new MethodSerialImpl(method);
                newMethodList.add(serializableMethod);
            }
            this.serializableMethods.put(event, newMethodList);
        }
    }

    private Class getListenerClass(ClassLoader loader) {
        Class entityListenerClass;
        block5: {
            entityListenerClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        entityListenerClass = AccessController.doPrivileged(new PrivilegedClassForName(this.listenerClassName, true, loader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.unableToLoadClass(this.listenerClassName, exception.getException());
                    }
                }
                entityListenerClass = PrivilegedAccessHelper.getClassForName(this.listenerClassName, true, loader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.unableToLoadClass(this.listenerClassName, exception);
            }
        }
        return entityListenerClass;
    }

    public void addEventMethod(String event, Method method) {
        if (!this.getMethods().containsKey(event)) {
            ArrayList<Method> methodsList = new ArrayList<Method>();
            methodsList.add(method);
            this.serializableMethods.put(event, methodsList);
        }
        MethodSerialImpl convertedMethod = new MethodSerialImpl(method);
        this.serializableMethods.get(event).add(convertedMethod);
    }

    public Hashtable<String, List<Method>> convertToMethods(ClassLoader loader) {
        Hashtable<String, List<Method>> table = new Hashtable<String, List<Method>>();
        for (String event : this.serializableMethods.keySet()) {
            List<MethodSerialImpl> methodList = this.serializableMethods.get(event);
            ArrayList<Method> newMethodList = new ArrayList<Method>();
            for (MethodSerialImpl serializedMethod : methodList) {
                try {
                    Method method = serializedMethod.convertToMethod(loader);
                    newMethodList.add(method);
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            table.put(event, newMethodList);
        }
        return table;
    }

    public Hashtable<String, List<MethodSerialImpl>> getMethods() {
        if (this.serializableMethods == null) {
            this.serializableMethods = new Hashtable();
        }
        return this.serializableMethods;
    }
}

