/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class BoundedByteArrayOutputStream
extends ByteArrayOutputStream {
    private int limit;

    public BoundedByteArrayOutputStream(int capacity) {
        this(capacity, capacity);
    }

    public BoundedByteArrayOutputStream(int capacity, int limit) {
        super(capacity);
        this.limit = limit;
    }

    @Override
    public void write(int b) {
        if (this.count + 1 > this.limit) {
            throw new RuntimeException("Reach the limit of the buffer.");
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.count + len > this.limit) {
            throw new RuntimeException("Reach the limit of the buffer");
        }
        super.write(b, off, len);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

