/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import fr.amapj.common.AmapjRuntimeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static Date fixedDate = null;

    public static Date getDate() {
        if (fixedDate != null) {
            return fixedDate;
        }
        return new Date();
    }

    public static void developperModeSetDate(String dateTime) {
        String pattern = "dd/MM/yyyy HH:mm:ss";
        if (pattern.length() != dateTime.length()) {
            throw new AmapjRuntimeException("Erreur sur le format de la date");
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            fixedDate = df.parse(dateTime);
        }
        catch (ParseException parseException) {
            throw new AmapjRuntimeException("Erreur sur date :" + dateTime);
        }
    }

    public static Date getDateWithNoTime() {
        return DateUtils.suppressTime(DateUtils.getDate());
    }

    public static Date suppressTime(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        return c.getTime();
    }

    public static Date firstMonday(Date d) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.setTime(d);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        int delta = c.get(7);
        if (delta == 1) {
            c.add(5, -6);
        } else {
            c.add(5, 2 - delta);
        }
        return c.getTime();
    }

    public static Date firstDayInMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.setTime(d);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        int delta = c.get(5);
        c.add(5, 1 - delta);
        return c.getTime();
    }

    public static int getDayInMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(5);
    }

    public static int getDayOfWeekInMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(8);
    }

    public static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public static Date addHour(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, amount);
        return c.getTime();
    }

    public static Date addMinute(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, amount);
        return c.getTime();
    }

    public static Date addMonth(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, amount);
        return c.getTime();
    }

    public static Date addYear(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, amount);
        return c.getTime();
    }

    public static int getDeltaDay(Date d1, Date d2) {
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }

    public static boolean equals(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.equals(d2);
    }

    public static boolean isInIntervalle(Date ref, Date debut, Date fin) {
        if (ref.after(fin)) {
            return false;
        }
        return !ref.before(debut);
    }

    public static void main(String[] args) throws ParseException {
        Date d = new SimpleDateFormat("dd/MM/yyyy").parse("17/09/2013");
        System.out.println("d=" + DateUtils.addMonth(d, 1));
    }

    public static LocalDateTime getLocalDateTime() {
        return DateUtils.asLocalDateTime(DateUtils.getDate());
    }

    public static LocalDate getLocalDate() {
        return DateUtils.asLocalDate(DateUtils.getDate());
    }

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static int getYear(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(1);
    }

    public static boolean isSameMonthAndYear(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        c1.set(14, 0);
        c1.set(13, 0);
        c1.set(12, 0);
        c1.set(11, 0);
        c1.set(5, 1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        c2.set(14, 0);
        c2.set(13, 0);
        c2.set(12, 0);
        c2.set(11, 0);
        c2.set(5, 1);
        return c1.equals(c2);
    }
}

