/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import fr.amapj.common.DateUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

public class FormatUtils {
    public static SimpleDateFormat getTimeStd() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    }

    public static SimpleDateFormat getStdDate() {
        return new SimpleDateFormat("dd/MM/yy");
    }

    public static SimpleDateFormat getLiteralMonthDate() {
        return new SimpleDateFormat("dd MMMMM yyyy");
    }

    public static SimpleDateFormat getFullDate() {
        return new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    }

    public static SimpleDateFormat getDateFile() {
        return new SimpleDateFormat("dd-MM-yyyy");
    }

    public static SimpleDateFormat getMoisFile() {
        return new SimpleDateFormat("MM-yyyy");
    }

    public static SimpleDateFormat getMoisFullText() {
        return new SimpleDateFormat("MMMMM yyyy");
    }

    public static String formatTrimestreFile(Date startDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("Q-yyyy");
        return "T" + DateUtils.asLocalDate(startDate).format(formatter);
    }

    public static String formatTrimestreFullText(Date startDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM");
        LocalDate l = DateUtils.asLocalDate(startDate);
        String str = l.format(formatter);
        l = l.plusMonths(1L);
        str = String.valueOf(str) + " - " + l.format(formatter);
        l = l.plusMonths(1L);
        str = String.valueOf(str) + " - " + l.format(formatter);
        formatter = DateTimeFormatter.ofPattern("yyyy");
        str = String.valueOf(str) + " - " + l.format(formatter);
        return str;
    }

    public static String div2int2digit(int a, int b) {
        if (a % b == 0) {
            return "" + a / b;
        }
        DecimalFormat df = new DecimalFormat(".00");
        return df.format((double)a / (double)b);
    }

    public static String listeDate(List<Date> dates) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        if (dates.size() == 0) {
            return "";
        }
        if (dates.size() == 1) {
            return "le " + df.format(dates.get(0));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("les ");
        int i = 0;
        while (i < dates.size() - 2) {
            buf.append(String.valueOf(df.format(dates.get(i))) + ", ");
            ++i;
        }
        buf.append(String.valueOf(df.format(dates.get(dates.size() - 2))) + " et ");
        buf.append(df.format(dates.get(dates.size() - 1)));
        return buf.toString();
    }

    public static <T> String puceDate(List<T> dates, GenericUtils.GetFieldTyped<T, Date> f1) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (T date : dates) {
            Date d = f1.getField(date);
            sb.append("<li>");
            sb.append(df.format(d));
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static String puceDate(List<Date> dates) {
        return FormatUtils.puceDate(dates, e -> e);
    }

    public static String prix(int montant) {
        return String.valueOf(new CurrencyTextFieldConverter().convertToString(montant)) + " \u20ac";
    }
}

