/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

public class StackUtils {
    public static final String SEP = System.getProperty("line.separator");

    public static void popStack(List<String> messages, Throwable e1) {
        if (e1 == null) {
            return;
        }
        messages.add(String.valueOf(e1.getClass().toString()) + " : " + e1.getMessage());
        if (e1 instanceof ConstraintViolationException) {
            Set set = ((ConstraintViolationException)e1).getConstraintViolations();
            for (ConstraintViolation constraintViolation : set) {
                String str = "Le champ " + constraintViolation.getPropertyPath() + " : " + constraintViolation.getMessage() + ". Valeur incorrecte : " + constraintViolation.getInvalidValue() + " Bean :" + constraintViolation.getLeafBean();
                messages.add(str);
            }
        }
        StackTraceElement[] elts = e1.getStackTrace();
        int i = 0;
        while (i < elts.length) {
            messages.add("at " + elts[i].toString());
            ++i;
        }
        if (e1.getCause() != null) {
            messages.add("Cause : ");
            StackUtils.popStack(messages, e1.getCause());
        }
    }

    public static String asString(Throwable e1) {
        StringBuffer result = new StringBuffer();
        ArrayList<String> messages = new ArrayList<String>();
        StackUtils.popStack(messages, e1);
        for (String str : messages) {
            result.append(str);
            result.append(SEP);
        }
        return result.toString();
    }

    public static String getConstraints(ConstraintViolationException e) {
        StringBuffer result = new StringBuffer();
        Set set = e.getConstraintViolations();
        for (ConstraintViolation constraintViolation : set) {
            result.append("Le champ ");
            result.append(constraintViolation.getPropertyPath());
            result.append(" : ");
            result.append(constraintViolation.getMessage());
            result.append(". Valeur incorrecte : ");
            result.append(constraintViolation.getInvalidValue());
            result.append(SEP);
        }
        return result.toString();
    }
}

