/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common.collections;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.collections.ComparatorByField;
import fr.amapj.common.collections.ab.TwoGetFieldHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class G1D<LIG, INITIAL> {
    private List<INITIAL> items;
    private List<Cell1<LIG, INITIAL>> content = new ArrayList<Cell1<LIG, INITIAL>>();
    private List<TwoGetFieldHolder<LIG, INITIAL>> ligSortGetField = new ArrayList<TwoGetFieldHolder<LIG, INITIAL>>();
    private List<Boolean> ligSortAscendant = new ArrayList<Boolean>();
    private List<GenericUtils.GetField<INITIAL>> cellSortGetField = new ArrayList<GenericUtils.GetField<INITIAL>>();
    private List<Boolean> cellSortAscendant = new ArrayList<Boolean>();
    private GenericUtils.GetFieldTyped<INITIAL, LIG> groupBy;
    private boolean computeDone = false;
    private List<LIG> fixedLigs = null;

    public G1D<LIG, INITIAL> fill(List<INITIAL> items) {
        this.items = items;
        return this;
    }

    public G1D<LIG, INITIAL> groupBy(GenericUtils.GetFieldTyped<INITIAL, LIG> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public G1D<LIG, INITIAL> fixedLigs(List<LIG> fixedLigs) {
        this.fixedLigs = fixedLigs;
        return this;
    }

    public G1D<LIG, INITIAL> sortLig(GenericUtils.GetField<LIG> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(f);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
        return this;
    }

    public G1D<LIG, INITIAL> sortLigNatural(boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(e -> e);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
        return this;
    }

    public G1D<LIG, INITIAL> sortLigAdvanced(GenericUtils.GetField<INITIAL> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initB(f);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
        return this;
    }

    public G1D<LIG, INITIAL> sortCell(GenericUtils.GetField<INITIAL> f, boolean asc) {
        this.cellSortGetField.add(f);
        this.cellSortAscendant.add(asc);
        return this;
    }

    public G1D<LIG, INITIAL> sortCellNatural(boolean asc) {
        this.cellSortGetField.add(e -> e);
        this.cellSortAscendant.add(asc);
        return this;
    }

    public G1D<LIG, INITIAL> compute() {
        ComparatorByField<Cell1> comparator;
        if (this.groupBy == null) {
            throw new AmapjRuntimeException("Vous devez appeler d'abord la m\u00e9thode groupBy");
        }
        Map<Object, List<Object>> map = this.items.stream().collect(Collectors.groupingBy(e -> this.groupBy.getField(e)));
        Stream<Cell1> s = null;
        s = this.fixedLigs == null ? map.entrySet().stream().map(e -> new Cell1(e.getKey(), (List)e.getValue())) : this.fixedLigs.stream().map(e -> new Cell1(e, map.getOrDefault(e, new ArrayList())));
        if (this.ligSortGetField.size() > 0) {
            comparator = new ComparatorByField<Cell1>();
            int i = 0;
            while (i < this.ligSortGetField.size()) {
                boolean asc;
                GenericUtils.GetField<Object> f;
                TwoGetFieldHolder<LIG, INITIAL> holder = this.ligSortGetField.get(i);
                if (holder.isA()) {
                    f = holder.getGetFieldA();
                    asc = this.ligSortAscendant.get(i);
                    comparator.add(e -> f.getField(e.lig), asc);
                } else {
                    f = holder.getGetFieldB();
                    asc = this.ligSortAscendant.get(i);
                    comparator.add(e -> f.getField(e.ref), asc);
                }
                ++i;
            }
            s = s.sorted(comparator);
        }
        this.content = s.collect(Collectors.toList());
        if (this.cellSortGetField.size() > 0) {
            comparator = new ComparatorByField(this.cellSortGetField, this.cellSortAscendant);
            for (Cell1<LIG, INITIAL> cell : this.content) {
                Collections.sort(cell.values, comparator);
            }
        }
        this.computeDone = true;
        return this;
    }

    public List<LIG> getKeys() {
        this.checkComputeDone();
        return this.content.stream().map(e -> e.lig).collect(Collectors.toList());
    }

    public List<Cell1<LIG, INITIAL>> getFullCells() {
        this.checkComputeDone();
        return this.content;
    }

    public Cell1<LIG, INITIAL> getFullCell(int index) {
        this.checkComputeDone();
        return this.content.get(index);
    }

    public List<List<INITIAL>> getCells() {
        this.checkComputeDone();
        return this.content.stream().map(e -> e.values).collect(Collectors.toList());
    }

    public List<INITIAL> getCell(int index) {
        return this.content.get((int)index).values;
    }

    private void checkComputeDone() {
        if (!this.computeDone) {
            throw new AmapjRuntimeException("Vous devez d'abord appeler la m\u00e9thode compute");
        }
    }

    public <T> List<T> getAs(Function<Cell1<LIG, INITIAL>, T> function) {
        this.checkComputeDone();
        return this.content.stream().map(e -> function.apply((Cell1)e)).collect(Collectors.toList());
    }

    public static <LIG, INITIAL> G1D<LIG, INITIAL> groupBy(List<INITIAL> items, GenericUtils.GetFieldTyped<INITIAL, LIG> groupBy) {
        G1D<LIG, INITIAL> g1d = new G1D<LIG, INITIAL>();
        g1d.fill(items);
        g1d.groupBy(groupBy);
        return g1d;
    }

    public static class Cell1<LIG, INITIAL> {
        public LIG lig;
        public INITIAL ref;
        public List<INITIAL> values = new ArrayList<INITIAL>();

        public Cell1(LIG lig, List<INITIAL> values) {
            this.lig = lig;
            this.values = values;
            this.ref = CollectionUtils.getFirstOrNull(values);
        }
    }
}

