/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common.collections;

import fr.amapj.common.AmapjRuntimeException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class M2<L1, L2, KEY extends Comparable, VAL1, VAL2> {
    private List<L2> l2;
    private List<L1> l1;
    private Function<L1, KEY> key1;
    private Function<L2, KEY> key2;
    private Function<L1, VAL1> val1;
    private Function<L2, VAL2> val2;
    private Function<KEY, VAL1> defaultVal1;
    private Function<KEY, VAL2> defaultVal2;

    public void setL1(List<L1> l1, Function<L1, KEY> key1, Function<L1, VAL1> val1, Function<KEY, VAL1> defaultVal1) {
        this.l1 = l1;
        this.key1 = key1;
        this.val1 = val1;
        this.defaultVal1 = defaultVal1;
    }

    public void setL2(List<L2> l2, Function<L2, KEY> key2, Function<L2, VAL2> val2, Function<KEY, VAL2> defaultVal2) {
        this.l2 = l2;
        this.key2 = key2;
        this.val2 = val2;
        this.defaultVal2 = defaultVal2;
    }

    public List<Pair<KEY, VAL1, VAL2>> get() {
        Stream<Pair> s1 = this.l1.stream().map((? super T e) -> this.createPairFromL1(e));
        Stream<Pair> s2 = this.l2.stream().map((? super T e) -> this.createPairFromL2(e));
        Set vals = Stream.concat(s1, s2).collect(Collectors.toMap(e -> e.key, Function.identity(), (p1, p2) -> this.merge((Pair<KEY, VAL1, VAL2>)p1, (Pair<KEY, VAL1, VAL2>)p2))).entrySet();
        return vals.stream().sorted((k1, k2) -> ((Comparable)k1.getKey()).compareTo(k2.getKey())).map((? super T e) -> this.map((Pair)e.getValue())).collect(Collectors.toList());
    }

    private Pair<KEY, VAL1, VAL2> createPairFromL1(L1 l1) {
        Pair p = new Pair();
        p.key = (Comparable)this.key1.apply(l1);
        p.v1 = this.val1.apply(l1);
        p.v1filled = true;
        p.v2filled = false;
        return p;
    }

    private Pair<KEY, VAL1, VAL2> createPairFromL2(L2 l2) {
        Pair p = new Pair();
        p.key = (Comparable)this.key2.apply(l2);
        p.v2 = this.val2.apply(l2);
        p.v1filled = false;
        p.v2filled = true;
        return p;
    }

    private Pair<KEY, VAL1, VAL2> merge(Pair<KEY, VAL1, VAL2> p1, Pair<KEY, VAL1, VAL2> p2) {
        if (p1.v1filled && p2.v1filled) {
            throw new AmapjRuntimeException("Dans la liste L1, il y a des elements diff\u00e9rents avec la m\u00eame cl\u00e9");
        }
        if (p1.v2filled && p2.v2filled) {
            throw new AmapjRuntimeException("Dans la liste L2, il y a des elements diff\u00e9rents avec la m\u00eame cl\u00e9");
        }
        if (p1.v1filled) {
            p1.v2 = p2.v2;
            p1.v2filled = true;
        } else {
            p1.v1 = p2.v1;
            p1.v1filled = true;
        }
        return p1;
    }

    private Pair<KEY, VAL1, VAL2> map(Pair<KEY, VAL1, VAL2> pair) {
        if (!pair.v1filled && this.defaultVal1 != null) {
            pair.v1 = this.defaultVal1.apply(pair.key);
        }
        if (!pair.v2filled && this.defaultVal2 != null) {
            pair.v2 = this.defaultVal2.apply(pair.key);
        }
        return pair;
    }

    public static <L1, L2, KEY extends Comparable, VAL1, VAL2> M2<L1, L2, KEY, VAL1, VAL2> merge(List<L1> l1, Function<L1, KEY> key1, Function<L1, VAL1> val1, Function<KEY, VAL1> defaultVal1, List<L2> l2, Function<L2, KEY> key2, Function<L2, VAL2> val2, Function<KEY, VAL2> defaultVal2) {
        M2<L1, L2, KEY, VAL1, VAL2> m2 = new M2<L1, L2, KEY, VAL1, VAL2>();
        m2.setL1(l1, key1, val1, defaultVal1);
        m2.setL2(l2, key2, val2, defaultVal2);
        return m2;
    }

    public static class Pair<KEY extends Comparable, VAL1, VAL2> {
        public boolean v1filled;
        public boolean v2filled;
        public KEY key;
        public VAL1 v1;
        public VAL2 v2;
    }
}

