/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common.periode;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.periode.TypPeriode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.threeten.extra.YearQuarter;

public class PeriodeManager {
    private TypPeriode typPeriode;
    private LocalDateTime now;
    private int nbJourAvant;
    private int nbJourApres;
    private BiFunction<LocalDate, LocalDate, List<LocalDate>> allowedDateProvider;

    public PeriodeManager(LocalDateTime now, TypPeriode typPeriode, int nbJourAvant, int nbJourApres, BiFunction<LocalDate, LocalDate, List<LocalDate>> allowedDateProvider) {
        this.now = now;
        this.typPeriode = typPeriode;
        this.nbJourAvant = nbJourAvant;
        this.nbJourApres = nbJourApres;
        this.allowedDateProvider = allowedDateProvider;
    }

    public PeriodeManager(LocalDateTime now, TypPeriode typPeriode, int nbJourAvant, int nbJourApres) {
        this(now, typPeriode, nbJourAvant, nbJourApres, null);
    }

    public List<Periode> getAllPeriodes() {
        switch (this.typPeriode) {
            case JOUR: {
                return this.getJour();
            }
            case MOIS: {
                return this.getMois();
            }
            case TRIMESTRE: {
                return this.getTrimestre();
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<Periode> getJour() {
        if (this.allowedDateProvider == null) {
            throw new AmapjRuntimeException();
        }
        LocalDate first = this.now.toLocalDate().minusDays(this.nbJourApres);
        LocalDate last = this.now.toLocalDate().plusDays(this.nbJourAvant);
        ArrayList<Periode> res = new ArrayList<Periode>();
        List<LocalDate> ls = this.allowedDateProvider.apply(first, last);
        for (LocalDate l : ls) {
            Periode p = new Periode();
            p.typPeriode = TypPeriode.JOUR;
            p.startDate = l;
            p.endDate = l;
            res.add(p);
        }
        return res;
    }

    private List<Periode> getMois() {
        ArrayList<Periode> res = new ArrayList<Periode>();
        YearMonth first = this.now.toLocalDate().minusDays(this.nbJourApres).query(YearMonth::from);
        YearMonth last = this.now.toLocalDate().plusDays(this.nbJourAvant).query(YearMonth::from);
        while (first.isBefore(last) || first.equals(last)) {
            Periode p = new Periode();
            p.typPeriode = TypPeriode.MOIS;
            p.startDate = first.atDay(1);
            p.endDate = first.atEndOfMonth();
            res.add(p);
            first = first.plusMonths(1L);
        }
        return res;
    }

    private List<Periode> getTrimestre() {
        ArrayList<Periode> res = new ArrayList<Periode>();
        YearQuarter first = this.now.toLocalDate().minusDays(this.nbJourApres).query(YearQuarter::from);
        YearQuarter last = this.now.toLocalDate().plusDays(this.nbJourAvant).query(YearQuarter::from);
        while (first.isBefore(last) || first.equals((Object)last)) {
            Periode p = new Periode();
            p.typPeriode = TypPeriode.TRIMESTRE;
            p.startDate = first.atDay(1);
            p.endDate = first.atEndOfQuarter();
            res.add(p);
            first = first.plusQuarters(1L);
        }
        return res;
    }

    public static class Periode {
        public TypPeriode typPeriode;
        public LocalDate startDate;
        public LocalDate endDate;

        public String getLib() {
            switch (this.typPeriode) {
                case JOUR: {
                    return FormatUtils.getFullDate().format(DateUtils.asDate(this.startDate));
                }
                case MOIS: {
                    return FormatUtils.getMoisFullText().format(DateUtils.asDate(this.startDate));
                }
                case TRIMESTRE: {
                    return FormatUtils.formatTrimestreFullText(DateUtils.asDate(this.startDate));
                }
            }
            throw new AmapjRuntimeException();
        }
    }
}

