/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.rdblink;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.rdblink.RdbLinkResult;
import fr.amapj.model.engine.transaction.TransactionHelper;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

public class RdbLink {
    private EntityManager em;
    private Query q;

    public RdbLink(EntityManager em) {
        this.em = em;
    }

    public static RdbLink get() {
        return TransactionHelper.get();
    }

    public void persist(Object entity) {
        this.checkInWriteTransaction();
        this.em.persist(entity);
    }

    private void checkInWriteTransaction() {
        if (!this.em.getTransaction().isActive()) {
            throw new AmapjRuntimeException("Tentative d'\u00e9criture dans une transaction en lecture");
        }
    }

    public void remove(Object entity) {
        this.checkInWriteTransaction();
        this.em.remove(entity);
    }

    public void removeOrNull(Object entity) {
        if (entity != null) {
            this.checkInWriteTransaction();
            this.em.remove(entity);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T findOrNull(Class<T> entityClass, Long id) {
        if (id == null) {
            return null;
        }
        return (T)this.em.find(entityClass, (Object)id);
    }

    public Query createQuery(String qlString) {
        this.q = this.em.createQuery(qlString);
        return this.q;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery tq = this.em.createQuery(criteriaQuery);
        this.q = tq;
        return tq;
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        TypedQuery tq = this.em.createQuery(qlString, resultClass);
        this.q = tq;
        return tq;
    }

    public Query createNativeQuery(String sqlString) {
        this.q = this.em.createNativeQuery(sqlString);
        return this.q;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.em.getCriteriaBuilder();
    }

    public void setParameter(String name, Object value) {
        this.q.setParameter(name, value);
    }

    public void setParameter(String name, Date value, TemporalType temporalType) {
        this.q.setParameter(name, value, temporalType);
    }

    public RdbLinkResult result() {
        Query query = this.q;
        this.q = null;
        return new RdbLinkResult(query);
    }

    public EntityManager getEm() {
        return this.em;
    }
}

