/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.tools;

import fr.amapj.common.DateUtils;
import fr.amapj.common.DevPath;
import fr.amapj.common.RandomUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.dbms.hsqlinternal.HsqlInternalDbmsConf;
import fr.amapj.model.models.param.SmtpType;
import fr.amapj.model.models.saas.TypDbExemple;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;

public class DbManagementTools {
    private Scanner sc;

    public static void main(String[] args) throws IOException {
        new DbManagementTools().execute();
    }

    private void execute() throws IOException {
        this.sc = new Scanner(System.in);
        String choix = this.ask("Que voulez vous faire ?\n1 : Cr\u00e9er une base de donn\u00e9es de DEV classique (mode hsql external)\n2 : Cr\u00e9er une base de donnes de DEV mode master(mode hsql internal)\n3 : Cr\u00e9er les bases pour la distribution\n4 : Cr\u00e9er une base de production\n");
        switch (choix.charAt(0)) {
            case '1': {
                this.devBaseClassique();
                break;
            }
            case '2': {
                this.devBaseMaster();
                break;
            }
            case '3': {
                this.distBase();
                break;
            }
            case '4': {
                this.prodBase();
            }
        }
    }

    private void devBaseClassique() throws IOException {
        this.s("Cr\u00e9ation d'une base de donn\u00e9es de dev classique");
        this.s("Il faut arreter la base de donn\u00e9es et le serveur , et effacer tous les fichiers dans le repertoire db/data");
        this.ask("Appuyez sur entr\u00e9e quand cela est fait");
        this.doDevBaseClassique();
        this.s("Tout est pr\u00eat , l'utilisateur MASTER est master@example.fr, mot de passe a");
    }

    private void doDevBaseClassique() throws IOException {
        DbManager dbManager = this.createHsqlInternalDbms();
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.nomInstance = "master";
        dto.nomAmap = "MASTER";
        dto.villeAmap = "MASTER";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 0;
        dto.url = "xx";
        dto.typDbExemple = TypDbExemple.BASE_MASTER;
        dto.user1Nom = "MASTER";
        dto.user1Prenom = "Master";
        dto.user1Email = "master@example.fr";
        dto.password = "a";
        dto.dbUserName = "SA";
        dto.dbPassword = "";
        dbManager.createDataBase(dto);
        dto = new AppInstanceDTO();
        dto.nomInstance = "amap1";
        dto.nomAmap = "AMAP1";
        dto.villeAmap = "VILLE AMAP1";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 200;
        dto.url = "http://amapj.fr/";
        Date d1 = DateUtils.addDays(DateUtils.getDate(), 10);
        Date d2 = DateUtils.firstMonday(d1);
        Date d3 = DateUtils.addDays(d2, 3);
        Date d4 = DateUtils.addDays(d2, 56);
        dto.dateDebut = d3;
        dto.dateFin = d4;
        dto.dateFinInscription = DateUtils.addDays(d3, -1);
        dto.typDbExemple = TypDbExemple.BASE_EXEMPLE;
        dto.password = "a";
        dbManager.createDataBase(dto);
        dbManager.stopDbms();
    }

    private void devBaseMaster() throws IOException {
        this.s("Cr\u00e9ation d'une base de donn\u00e9es de dev MASTER");
        this.s("Il faut arreter la base de donn\u00e9es et le serveur , et effacer tous les fichiers dans le repertoire db/data");
        this.ask("Appuyez sur entr\u00e9e quand cela est fait");
        this.doDevBaseMaster();
        this.s("Il faut ensuite copier /build-tools/files-dev/master_mode/context.xml dans /amapj/WebContent/META-INF/context.xml");
        this.s("Tout est pr\u00eat , l'utilisateur MASTER est master@example.fr, mot de passe a");
    }

    private void doDevBaseMaster() {
        DbManager dbManager = this.createHsqlInternalDbms();
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.nomInstance = "master";
        dto.nomAmap = "MASTER";
        dto.villeAmap = "MASTER";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 0;
        dto.url = "xx";
        dto.typDbExemple = TypDbExemple.BASE_MASTER;
        dto.user1Nom = "MASTER";
        dto.user1Prenom = "Master";
        dto.user1Email = "master@example.fr";
        dto.password = "a";
        dbManager.createDataBase(dto);
        dto = new AppInstanceDTO();
        dto.nomInstance = "amap1";
        dto.nomAmap = "AMAP1";
        dto.villeAmap = "VILLE AMAP1";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 200;
        dto.url = "http://amapj.fr/";
        Date d1 = DateUtils.addDays(DateUtils.getDate(), 10);
        Date d2 = DateUtils.firstMonday(d1);
        Date d3 = DateUtils.addDays(d2, 3);
        Date d4 = DateUtils.addDays(d2, 56);
        dto.dateDebut = d3;
        dto.dateFin = d4;
        dto.dateFinInscription = DateUtils.addDays(d3, -1);
        dto.typDbExemple = TypDbExemple.BASE_EXEMPLE;
        dto.password = "a";
        dbManager.createDataBase(dto);
        dbManager.stopDbms();
    }

    private void distBase() throws IOException {
        this.s("Cr\u00e9ation d'une base de donn\u00e9es pour la distribution");
        this.s("Il faut arreter la base de donn\u00e9es et le serveur.");
        this.ask("Appuyez sur entr\u00e9e quand cela est fait");
        this.doDistBase();
        this.s("Voir la suite des instructions dans /docs/tech-notes/admin/creation_version/creation_version.txt");
    }

    private void doDistBase() {
        DbManager dbManager = this.createHsqlInternalDbms();
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.nomInstance = "m1";
        dto.nomAmap = "MASTER";
        dto.villeAmap = "MASTER";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 0;
        dto.url = "xx";
        dto.typDbExemple = TypDbExemple.BASE_MASTER;
        dbManager.createDataBase(dto);
        dto = new AppInstanceDTO();
        dto.nomInstance = "a1";
        dto.nomAmap = "AMAP1";
        dto.villeAmap = "VILLE AMAP1";
        dto.smtpType = SmtpType.GMAIL;
        dto.adrMailSrc = "";
        dto.nbMailMax = 200;
        dto.url = "http://amapj.fr/";
        Date d1 = DateUtils.addDays(DateUtils.getDate(), 80);
        Date d2 = DateUtils.firstMonday(d1);
        Date d3 = DateUtils.addDays(d2, 3);
        Date d4 = DateUtils.addDays(d2, 84);
        dto.dateDebut = d3;
        dto.dateFin = d4;
        dto.dateFinInscription = d3;
        dto.typDbExemple = TypDbExemple.BASE_EXEMPLE;
        dto.password = "a";
        dbManager.createDataBase(dto);
        dbManager.stopDbms();
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM yyyy");
        System.out.println("===================================================");
        System.out.println("f[\"d1\"]=\"" + df.format(d3) + "\";");
        System.out.println("f[\"d2\"]=\"" + df.format(d3) + "\";");
        System.out.println("f[\"d3\"]=\"" + df.format(d3) + "\";");
        System.out.println("f[\"d4\"]=\"" + df.format(d4) + "\";");
        System.out.println("===================================================");
    }

    private void prodBase() throws IOException {
        this.s("Cr\u00e9ation d'une base de donn\u00e9es pour la production");
        this.s("Il faut arreter la base de donn\u00e9es et le serveur.");
        String name = this.ask("Merci de saisir le nom de la base ", "s7");
        String password = this.doProdBase(name);
        System.out.println("===================================================");
        System.out.println("La base est cr\u00e9\u00e9e , password = " + password);
        System.out.println("===================================================");
    }

    private String doProdBase(String name) {
        String password = RandomUtils.generatePasswordMin(8);
        DbManager dbManager = this.createHsqlInternalDbms();
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.nomInstance = String.valueOf(name.toLowerCase()) + "-master";
        dto.nomAmap = String.valueOf(name.toUpperCase()) + " MASTER";
        dto.villeAmap = String.valueOf(name.toUpperCase()) + " MASTER";
        dto.smtpType = SmtpType.POSTFIX_LOCAL;
        dto.adrMailSrc = String.valueOf(name.toUpperCase()) + "-master@m.amapj.fr";
        dto.nbMailMax = 100;
        dto.url = "https://" + name.toLowerCase() + ".amapj.fr/p/" + name.toLowerCase() + "-master";
        dto.typDbExemple = TypDbExemple.BASE_MASTER;
        dto.user1Nom = "MASTER";
        dto.user1Prenom = "master";
        dto.user1Email = "postmaster@amapj.fr";
        dto.password = password;
        dto.dbUserName = "SA";
        dto.dbPassword = "";
        dbManager.createDataBase(dto);
        dbManager.stopDbms();
        return password;
    }

    private DbManager createHsqlInternalDbms() {
        AmapJLogManager.setLogDir("../../../logs/");
        HsqlInternalDbmsConf conf = new HsqlInternalDbmsConf("xx");
        conf.contentDirectory = String.valueOf(DevPath.amapjdev()) + "/amapj/db/data";
        conf.port = 9001;
        DbManager.initialize(conf, null);
        DbManager.get().startDbms();
        return DbManager.get();
    }

    private void s(String s) {
        System.out.println(s);
    }

    private String ask(String message) {
        System.out.println(message);
        String str = this.sc.nextLine();
        return str;
    }

    private String ask(String message, String defaultValue) {
        String str = this.ask(String.valueOf(message) + "( exemple : " + defaultValue + " )");
        if (str.length() == 0) {
            System.out.println(defaultValue);
            return defaultValue;
        }
        return str;
    }
}

