/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.transaction;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.appinstance.AppState;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class DataBaseInfo {
    public String dbName;
    public String url;
    public String user;
    public String password;
    private AppState state;
    private int puNumber;
    private EntityManagerFactory entityManagerFactory;

    public DataBaseInfo(String dbName, String url, String user, String password, int puNumber) {
        this.dbName = dbName;
        this.url = url;
        this.user = user;
        this.password = password;
        this.state = AppState.OFF;
        this.puNumber = puNumber;
        this.entityManagerFactory = null;
    }

    public String getDbName() {
        return this.dbName;
    }

    public AppState getState() {
        return this.state;
    }

    public void setState(AppState state) {
        this.state = state;
    }

    public EntityManager createEntityManager() {
        if (this.state != AppState.ON) {
            throw new AmapjRuntimeException("L'application est en maintenance et n'est plus accessible.");
        }
        return this.entityManagerFactory.createEntityManager();
    }

    private EntityManagerFactory createEntityManagerFactory() {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("eclipselink.jdbc.platform", "org.eclipse.persistence.platform.database.HSQLPlatform");
        mp.put("javax.persistence.jdbc.driver", "org.hsqldb.jdbcDriver");
        mp.put("javax.persistence.jdbc.url", this.url);
        mp.put("javax.persistence.jdbc.user", this.user);
        mp.put("javax.persistence.jdbc.password", this.password);
        mp.put("eclipselink.logging.level", "INFO");
        mp.put("eclipselink.logging.level.sql", "FINE");
        mp.put("eclipselink.ddl-generation", "none");
        mp.put("eclipselink.logging.logger", "fr.amapj.model.engine.db.EclipseLinkLogger");
        DecimalFormat df = new DecimalFormat("000");
        String puName = "pu" + df.format(this.puNumber);
        return Persistence.createEntityManagerFactory((String)puName, mp);
    }

    public void closeEntityManagerFactory() {
        this.entityManagerFactory.close();
        this.entityManagerFactory = null;
    }

    public void renewEntityManagerFactory() {
        if (this.entityManagerFactory != null) {
            throw new AmapjRuntimeException("Il faut d'abord fermer EntityManagerFactory");
        }
        this.entityManagerFactory = this.createEntityManagerFactory();
    }
}

