/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.transaction;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.TransactionInfo;

public class TransactionHelper {
    public static TransactionHelper mainInstance = new TransactionHelper();
    private ThreadLocal<TransactionInfo> threadLocal = new ThreadLocal();

    public static RdbLink get() {
        TransactionInfo transactionInfo = TransactionHelper.mainInstance.threadLocal.get();
        if (transactionInfo.em == null) {
            throw new AmapjRuntimeException("Erreur annotation transaction");
        }
        return new RdbLink(transactionInfo.em);
    }

    public static TransactionInfo.Status getTransactionStatus() {
        TransactionInfo transactionInfo = TransactionHelper.mainInstance.threadLocal.get();
        return transactionInfo == null ? TransactionInfo.Status.VIDE : transactionInfo.getType();
    }

    public static int getNbAppel() {
        TransactionInfo transactionInfo = TransactionHelper.mainInstance.threadLocal.get();
        return transactionInfo == null ? 0 : transactionInfo.nbAppel;
    }

    public static Long getTransactionId() {
        TransactionInfo transactionInfo = TransactionHelper.mainInstance.threadLocal.get();
        return transactionInfo == null ? 0L : transactionInfo.idTransac;
    }

    public void start_read() {
        TransactionInfo transactionInfo = this.threadLocal.get();
        if (transactionInfo == null) {
            transactionInfo = new TransactionInfo();
            this.threadLocal.set(transactionInfo);
        }
        ++transactionInfo.nbAppel;
        if (transactionInfo.nbAppel == 1) {
            transactionInfo.startSessionLecture();
        }
    }

    public void stop_read(boolean rollback) {
        TransactionInfo transactionInfo = this.threadLocal.get();
        --transactionInfo.nbAppel;
        if (transactionInfo.nbAppel == 0) {
            transactionInfo.closeSession(rollback);
        }
    }

    public void start_write() {
        TransactionInfo transactionInfo = this.threadLocal.get();
        if (transactionInfo == null) {
            transactionInfo = new TransactionInfo();
            this.threadLocal.set(transactionInfo);
        }
        ++transactionInfo.nbAppel;
        if (transactionInfo.nbAppel == 1) {
            transactionInfo.startSessionEcriture();
        } else if (transactionInfo.getType() == TransactionInfo.Status.LECTURE) {
            transactionInfo.upgradeLectureToEcriture();
        }
    }

    public void stop_write(boolean rollback) {
        TransactionInfo transactionInfo = this.threadLocal.get();
        if (rollback && transactionInfo.nbAppel == 0) {
            return;
        }
        --transactionInfo.nbAppel;
        if (transactionInfo.nbAppel == 0) {
            transactionInfo.closeSession(rollback);
        }
    }
}

