/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.transaction;

import fr.amapj.model.engine.db.DbManager;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionInfo {
    private static final Logger logger = LogManager.getLogger((String)"SQL");
    private static final AtomicLong atomicLong = new AtomicLong();
    public int nbAppel = 0;
    public EntityManager em = null;
    public EntityTransaction transac = null;
    public Long idTransac;

    public Status getType() {
        if (this.transac != null) {
            return Status.ECRITURE;
        }
        if (this.em != null) {
            return Status.LECTURE;
        }
        return Status.VIDE;
    }

    public void startSessionLecture() {
        this.em = DbManager.get().getCurrentDb().createEntityManager();
        this.transac = null;
        this.idTransac = atomicLong.incrementAndGet();
        logger.info("id=" + this.idTransac + " D\u00e9but transaction lecture");
    }

    public void startSessionEcriture() {
        this.em = DbManager.get().getCurrentDb().createEntityManager();
        this.transac = this.em.getTransaction();
        this.transac.begin();
        this.idTransac = atomicLong.incrementAndGet();
        logger.info("id=" + this.idTransac + " D\u00e9but transaction \u00e9criture");
    }

    public void upgradeLectureToEcriture() {
        this.transac = this.em.getTransaction();
        this.transac.begin();
        logger.info("id=" + this.idTransac + " Upgrade transaction de lecture \u00e0 \u00e9criture");
    }

    public void closeSession(boolean rollback) {
        Status type = this.getType();
        EntityTransaction transac1 = this.transac;
        EntityManager em1 = this.em;
        this.nbAppel = 0;
        this.em = null;
        this.transac = null;
        switch (type) {
            case VIDE: {
                logger.warn("id=" + this.idTransac + " Erreur dans les transactions !! Impossible de fermer une session vide");
                break;
            }
            case LECTURE: {
                if (rollback) {
                    logger.info("id=" + this.idTransac + " Fin transaction en lecture sur exception");
                    em1.close();
                    break;
                }
                logger.info("id=" + this.idTransac + " Fin transaction en lecture");
                em1.close();
                break;
            }
            case ECRITURE: {
                if (rollback) {
                    logger.info("id=" + this.idTransac + " D\u00e9but rollback transaction en ecriture");
                    transac1.rollback();
                    em1.close();
                    logger.info("id=" + this.idTransac + " Fin rollback transaction en ecriture");
                    break;
                }
                logger.info("id=" + this.idTransac + " D\u00e9but commit transaction en ecriture");
                try {
                    transac1.commit();
                    em1.close();
                    logger.info("id=" + this.idTransac + " Fin commit transaction en ecriture");
                    break;
                }
                catch (RollbackException e) {
                    logger.info("id=" + this.idTransac + " Erreur lors du commit ");
                    throw e;
                }
            }
        }
    }

    public static enum Status {
        VIDE,
        LECTURE,
        ECRITURE;

    }
}

