/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.models.contrat.reel;

import fr.amapj.model.engine.Identifiable;
import fr.amapj.model.models.contrat.modele.ModeleContratDatePaiement;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.remise.RemiseProducteur;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"modeleContratDatePaiement_id", "contrat_id"})})
public class Paiement
implements Identifiable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long id;
    @NotNull
    @ManyToOne
    public Contrat contrat;
    @NotNull
    @ManyToOne
    public ModeleContratDatePaiement modeleContratDatePaiement;
    @NotNull
    public int montant;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public EtatPaiement etat = EtatPaiement.A_FOURNIR;
    @ManyToOne
    public RemiseProducteur remise;
    @Size(min=0, max=255)
    @Column(length=255)
    public String commentaire1;
    @Size(min=0, max=255)
    @Column(length=255)
    public String commentaire2;
    @Size(min=0, max=255)
    @Column(length=255)
    public String commentaire3;
    @Size(min=0, max=255)
    @Column(length=255)
    public String commentaire4;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }
}

