/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.samples.query;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;

public class SelectDbUtilisateurHsql {
    @DbRead
    public void listAllUser() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u");
            List us = q.getResultList();
            for (Utilisateur u : us) {
                System.out.println("Utilisateur: Nom =" + u.nom + " Prenom =" + u.prenom);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public void listUserWithNameAA() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u WHERE u.nom=:nom");
            q.setParameter("nom", (Object)"nom_a");
            List us = q.getResultList();
            for (Utilisateur u : us) {
                System.out.println("Utilisateur: Nom =" + u.nom + " Prenom =" + u.prenom);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public void listUserWithAContrat() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u WHERE EXISTS (select c from Contrat c where c.utilisateur = u)");
            List us = q.getResultList();
            for (Utilisateur u : us) {
                System.out.println("Utilisateur: Nom =" + u.nom + " Prenom =" + u.prenom);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public void complexrequest() throws ParseException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Long idUtilisateur = new Long(1052L);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
            ArrayList<Date> dates = new ArrayList<Date>();
            dates.add(df.parse("12/06/14"));
            dates.add(df.parse("19/06/14"));
            dates.add(df.parse("26/06/14"));
            dates.add(df.parse("03/07/14"));
            Query q = em.createQuery("select distinct(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.contrat.utilisateur=:u and c.modeleContratDate.dateLiv in :dates order by c.modeleContratDate.dateLiv");
            q.setParameter("u", (Object)em.find(Utilisateur.class, idUtilisateur));
            q.setParameter("dates", dates);
            List ds = q.getResultList();
            System.out.println("");
            for (Date date : ds) {
                System.out.println("Date: Nom =" + df.format(date));
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public void tochar_request() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createNativeQuery("select to_char(l.dateIn,'YYYY-MM-DD') , count(l.id) , count(distinct(l.idUtilisateur,l.dbName)) , sum(l.activityTime) from LogAccess l group by to_char(l.dateIn,'YYYY-MM-DD')");
            List ds = q.getResultList();
            System.out.println("");
            for (Object[] s : ds) {
                System.out.println("Date: Nom =" + s[0].getClass() + "==" + s[1].getClass() + "==" + s[3].getClass());
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void selectForUpdate() throws InterruptedException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u WHERE u.id=:id");
            q.setParameter("id", (Object)1052L);
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            List us = q.getResultList();
            for (Utilisateur u : us) {
                System.out.println("Utilisateur: Nom =" + u.nom + " Prenom =" + u.prenom);
            }
            int i = 0;
            while (i < 10) {
                System.out.println("Attente " + i);
                Thread.sleep(1000L);
                ++i;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public void listAllUserAndCheckCache() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u");
            List us = q.getResultList();
            for (Utilisateur u : us) {
                System.out.println("Utilisateur: Nom =" + u.nom + " Prenom =" + u.prenom);
            }
            IdentityMapAccessor ima = (IdentityMapAccessor)em.getEm().getEntityManagerFactory().getCache().unwrap(org.eclipse.persistence.sessions.IdentityMapAccessor.class);
            Iterator iter = ima.getIdentityMapManager().getIdentityMapClasses();
            while (iter.hasNext()) {
                Class clz = (Class)iter.next();
                System.out.println("Class = " + clz);
                Vector vs = ima.getAllFromIdentityMap(null, clz, null);
                for (Object v : vs) {
                    System.out.println("v=" + v);
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        TestTools.init();
        SelectDbUtilisateurHsql selectUtilisateur = new SelectDbUtilisateurHsql();
        System.out.println("Requete dans la base avec HSQL..");
        selectUtilisateur.listAllUserAndCheckCache();
        System.out.println("Fin de la requete");
    }
}

