/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.appinitializer;

import fr.amapj.common.DateUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.service.engine.appinitializer.StandardServletParameter;
import fr.amapj.service.engine.appinitializer.VelocityInitializer;
import fr.amapj.service.engine.objectstorage.ObjectStorageServiceProvider;
import fr.amapj.service.engine.objectstorage.deamon.ObjectStorageDeleteService;
import fr.amapj.service.services.advanced.tenantnotification.TenantNotificationService;
import fr.amapj.service.services.appinstance.DemarrageAppInstanceService;
import fr.amapj.service.services.backupdb.BackupDatabaseService;
import fr.amapj.service.services.logview.LogDeleteService;
import fr.amapj.service.services.notification.daily.NotificationDailyService;
import fr.amapj.service.services.notification.hourly.NotificationHourlyService;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.nio.charset.Charset;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@WebListener
public class AppInitializer
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger();
    Scheduler sched;

    public void contextDestroyed(ServletContextEvent event) {
        logger.info("Debut de l'arret de l'application");
        logger.info("Debut de l'arret des d\u00e9mons");
        this.stopDeamons();
        logger.info("Demons arretes");
        logger.info("Debut de l'arret des DBMS");
        DbManager.get().stopDbms();
        logger.info("DBMS arretes");
        ObjectStorageServiceProvider.close();
        this.deregisterDriver();
    }

    private void deregisterDriver() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                logger.info(String.format("deregistering jdbc driver: %s", driver));
            }
            catch (SQLException e) {
                logger.warn(String.valueOf(String.format("Error deregistering driver %s", driver)) + e.getMessage());
            }
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        AppConfiguration.load(new StandardServletParameter(event.getServletContext()));
        VelocityInitializer.load();
        ObjectStorageServiceProvider.initialize();
        logger.info("Utilisation du charset : " + Charset.defaultCharset());
        logger.info("Debut de d\u00e9marrage du DBMS");
        DbManager.initialize(AppConfiguration.getConf().getDbmsConf(), AppConfiguration.getConf().getMasterConf());
        DbManager.get().startDbms();
        logger.info("Fin de d\u00e9marrage du DBMS");
        logger.info("Debut de d\u00e9marrage de la base MASTER");
        DbManager.get().startMasterBase();
        logger.info("Fin de d\u00e9marrage de la base MASTER");
        new LogDeleteService().cleanLogFile();
        logger.info("Debut de d\u00e9marrage des bases additionnelles");
        new DemarrageAppInstanceService().startAllDbs();
        logger.info("Fin de d\u00e9marrage des bases additionnelles");
        logger.info("Debut de d\u00e9marrage des d\u00e9mons");
        this.startDeamons();
        logger.info("Demons d\u00e9marr\u00e9s");
    }

    private void startDeamons() {
        try {
            Date ref = DateUtils.addMinute(new Date(), 10);
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            this.sched = schedFact.getScheduler();
            this.sched.start();
            JobDetail job = JobBuilder.newJob(NotificationHourlyService.class).withIdentity("myJob1", "group1").build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger1", "group1").startAt(ref).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever()).build();
            this.sched.scheduleJob(job, trigger);
            Date ref2 = DateUtils.addMinute(ref, 20);
            job = JobBuilder.newJob(ObjectStorageDeleteService.class).withIdentity("myJob5", "group5").build();
            trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger5", "group5").startAt(ref2).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever()).build();
            this.sched.scheduleJob(job, trigger);
            job = JobBuilder.newJob(BackupDatabaseService.class).withIdentity("myJob2", "group2").build();
            trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger2", "group2").startAt(ref).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)5, (int)0)).build();
            this.sched.scheduleJob(job, trigger);
            job = JobBuilder.newJob(LogDeleteService.class).withIdentity("myJob3", "group3").build();
            trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger3", "group3").startAt(ref).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)4, (int)0)).build();
            this.sched.scheduleJob(job, trigger);
            job = JobBuilder.newJob(NotificationDailyService.class).withIdentity("myJob6", "group6").build();
            trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger6", "group6").startAt(ref).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)3, (int)0)).build();
            this.sched.scheduleJob(job, trigger);
            if (AppConfiguration.getConf().getMessagingCenterUrl() != null) {
                job = JobBuilder.newJob(TenantNotificationService.class).withIdentity("myJob4", "group4").build();
                trigger = TriggerBuilder.newTrigger().withIdentity("myTrigger4", "group4").startAt(ref).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever()).build();
                this.sched.scheduleJob(job, trigger);
            }
        }
        catch (SchedulerException e) {
            logger.warn("Impossible de demarrer correctement des d\u00e9mons" + StackUtils.asString(e));
        }
    }

    private void stopDeamons() {
        if (this.sched == null) {
            return;
        }
        try {
            this.sched.shutdown();
        }
        catch (SchedulerException e) {
            logger.warn("Impossible d'arreter correctement des d\u00e9mons" + StackUtils.asString(e));
        }
    }
}

