/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.deamons;

import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.appinstance.AppState;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.service.services.logview.LogViewService;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeamonsUtils {
    private static final Logger logger = LogManager.getLogger();

    @SafeVarargs
    public static void executeAsDeamon(Class clazz, Consumer<DeamonsContext> ... deamons) {
        ArrayList<DataBaseInfo> dataBaseInfos = new ArrayList<DataBaseInfo>(DbManager.get().getAllDbs());
        DeamonsUtils.internalExecuteAsDeamon(clazz, dataBaseInfos, deamons);
    }

    public static void executeAsDeamonInMaster(Class clazz, Consumer<DeamonsContext> ... deamons) {
        ArrayList<DataBaseInfo> dataBaseInfos = new ArrayList<DataBaseInfo>();
        dataBaseInfos.add(DbManager.get().getMasterDb());
        DeamonsUtils.internalExecuteAsDeamon(clazz, dataBaseInfos, deamons);
    }

    private static void internalExecuteAsDeamon(Class clazz, List<DataBaseInfo> dataBaseInfos, Consumer<DeamonsContext> ... deamons) {
        String deamonName = clazz.getSimpleName();
        for (DataBaseInfo dataBaseInfo : dataBaseInfos) {
            if (dataBaseInfo.getState() != AppState.ON) continue;
            LogAccessDTO dto = new LogViewService().saveAccess(deamonName, null, null, null, null, dataBaseInfo.getDbName(), TypLog.DEAMON, false);
            DeamonsContext deamonsContext = new DeamonsContext();
            DbManager.get().setDbForDeamonThread(dataBaseInfo);
            logger.info("D\u00e9but du d\u00e9mon " + deamonName + " pour la base " + dataBaseInfo.getDbName());
            int i = 0;
            while (i < deamons.length) {
                Consumer<DeamonsContext> deamonsImpl = deamons[i];
                try {
                    deamonsImpl.accept(deamonsContext);
                }
                catch (Throwable t) {
                    ++deamonsContext.nbError;
                    logger.info("Erreur sur le d\u00e9mon " + deamonName + " pour la base " + dataBaseInfo.getDbName() + "\n" + StackUtils.asString(t));
                }
                ++i;
            }
            logger.info("Fin du d\u00e9mon " + deamonName + " pour la base " + dataBaseInfo.getDbName());
            DbManager.get().setDbForDeamonThread(null);
            new LogViewService().endAccess(dto.id, deamonsContext.nbError);
            AmapJLogManager.endLog(true, dto.logFileName);
        }
    }
}

