/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.FileInfoDTO;
import fr.amapj.service.engine.generator.bin.AbstractBinGenerator;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.engine.generator.odt.AbstractOdtGenerator;
import fr.amapj.service.engine.generator.odt.OdtGeneratorTool;
import fr.amapj.service.engine.generator.pdf.AbstractPdfGenerator;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import fr.amapj.service.engine.generator.zip.AbstractZipGenerator;
import fr.amapj.service.engine.generator.zip.ZipGeneratorTool;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.odftoolkit.simple.TextDocument;

public class CoreGeneratorService {
    @DbRead
    public List<FileInfoDTO> getFileInfo(List<CoreGenerator> generators) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<FileInfoDTO> res = new ArrayList<FileInfoDTO>();
            for (CoreGenerator generator : generators) {
                FileInfoDTO dto = new FileInfoDTO();
                dto.fileName = generator.getFileName(em);
                dto.nameToDisplay = generator.getNameToDisplay(em);
                String suffix = generator.getNameToDisplaySuffix();
                if (suffix != null) {
                    dto.nameToDisplay = String.valueOf(dto.nameToDisplay) + suffix;
                }
                dto.extension = generator.getExtension();
                dto.generator = generator;
                res.add(dto);
            }
            ArrayList<FileInfoDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public FileInfoDTO getFileInfo(CoreGenerator generator) {
        ArrayList<CoreGenerator> generators = new ArrayList<CoreGenerator>();
        generators.add(generator);
        List<FileInfoDTO> res = this.getFileInfo(generators);
        return res.get(0);
    }

    @DbRead
    public Workbook getFichierExcel(AbstractExcelGenerator generator) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ExcelFormat format = generator.getFormat();
            ExcelGeneratorTool et = new ExcelGeneratorTool(format);
            generator.fillExcelFile(em, et);
            Workbook workbook = et.getWb();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return workbook;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public TextDocument getFichierOdt(AbstractOdtGenerator generator) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            OdtGeneratorTool et = new OdtGeneratorTool();
            generator.fillWordFile(em, et);
            TextDocument textDocument = et.getDoc();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return textDocument;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public PdfGeneratorTool getFichierPdf(AbstractPdfGenerator generator) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PdfGeneratorTool et = new PdfGeneratorTool();
            generator.fillPdfFile(em, et);
            PdfGeneratorTool pdfGeneratorTool = et;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return pdfGeneratorTool;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ZipGeneratorTool getFichierZip(AbstractZipGenerator generator) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ZipGeneratorTool et = new ZipGeneratorTool();
            generator.fillZipFile(em, et);
            ZipGeneratorTool zipGeneratorTool = et;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return zipGeneratorTool;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public byte[] getFichierBin(AbstractBinGenerator generator) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            byte[] byArray = generator.generateContent(em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return byArray;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

