/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.excel.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;

public class DiagonalBorder {
    public static void main(String[] args) throws Exception {
        DiagonalBorder diagonalBorder = new DiagonalBorder();
        diagonalBorder.execute();
    }

    private void execute() throws Exception {
        this.generateFileWithDiagonal();
    }

    private void generateBasicFile() throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("Amap");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        this.addRow(sheet, style, (short)0);
        this.addRow(sheet, style, (short)1);
        this.addRow(sheet, style, (short)2);
        FileOutputStream fos = new FileOutputStream("test1.xls");
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        System.out.println("OK !");
    }

    private HSSFRow addRow(HSSFSheet sheet, HSSFCellStyle style, short rowNumber) {
        HSSFRow row = sheet.createRow((int)rowNumber);
        HSSFCell c = row.createCell(0);
        c.setCellStyle(style);
        c.setCellValue(4.0);
        c = row.createCell(1);
        c.setCellStyle(style);
        c.setCellValue(4.0);
        c = row.createCell(2);
        c.setCellStyle(style);
        c.setCellValue("");
        return row;
    }

    private void readExcelFile() throws Exception {
        FileInputStream file = new FileInputStream(new File("test1.xls"));
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
        HSSFSheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.iterator();
        int i = 1;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            Cell cell = row.getCell(0);
            System.out.println("Affichage des infos de la cellule 1 de la ligne " + i);
            this.displayCell(cell);
            ++i;
        }
        file.close();
    }

    private void displayCell(Cell cell) throws Exception {
        CellStyle style = cell.getCellStyle();
        Field f = HSSFCellStyle.class.getDeclaredField("_format");
        f.setAccessible(true);
        ExtendedFormatRecord efr = (ExtendedFormatRecord)f.get(style);
        System.out.println("getAdtlDiag=" + efr.getAdtlDiag());
        System.out.println("getDiag=" + efr.getDiag());
        System.out.println("getAdtlDiagLineStyle=" + efr.getAdtlDiagLineStyle());
        System.out.println("isIndentNotParentBorder=" + efr.isIndentNotParentBorder());
    }

    private void generateFileWithDiagonal() throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("Amap");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        Field f = HSSFCellStyle.class.getDeclaredField("_format");
        f.setAccessible(true);
        ExtendedFormatRecord efr = (ExtendedFormatRecord)f.get(style);
        efr.setIndentNotParentBorder(true);
        efr.setDiag((short)3);
        efr.setAdtlDiag((short)64);
        efr.setAdtlDiagLineStyle((short)1);
        this.addRow(sheet, style, (short)0);
        this.addRow(sheet, style, (short)1);
        this.addRow(sheet, style, (short)2);
        FileOutputStream fos = new FileOutputStream("test2.xls");
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        System.out.println("OK !");
    }
}

