/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.excel.samples;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelCellAutoSize;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import java.io.IOException;
import org.apache.poi.ss.usermodel.Row;

public class EGTestAutoSize
extends AbstractExcelGenerator {
    int from;
    int to;

    public EGTestAutoSize(int from, int to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        int i = this.from;
        while (i <= this.to) {
            this.addOneSheet(i, et);
            ++i;
        }
    }

    private void addOneSheet(int largeur, ExcelGeneratorTool et) {
        et.addSheet("Largeur" + largeur, 3, largeur);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setCell(2, "Telephone", et.grasCentreBordure);
        int i = 1;
        while (i < 4 * largeur) {
            String cellValue = this.generate(i);
            this.addRow(et, String.valueOf(cellValue) + "1");
            ++i;
        }
    }

    private String generate(int len) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i % 4 == 0) {
                buf.append('a');
            } else if (i % 4 == 1) {
                buf.append('b');
            } else if (i % 4 == 2) {
                buf.append('c');
            } else {
                buf.append('D');
            }
            ++i;
        }
        return buf.toString();
    }

    private void addRow(ExcelGeneratorTool et, String cellValue) {
        Row currentRow = et.addRow();
        et.setCell(0, cellValue, et.nonGrasCentreBordure);
        et.setCell(1, "bob", et.grasCentreBordure);
        et.setCell(2, "0 1", et.grasCentreBordure);
        ExcelCellAutoSize info = new ExcelCellAutoSize(0);
        info.addCell(et.getColumnWidthInPoints(0), "Arial", 10);
        info.addLine(cellValue);
        info.autosize(currentRow);
    }

    @Override
    public String getFileName(RdbLink em) {
        return "essai";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "essai";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGTestAutoSize(10, 50).test();
    }
}

