/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.odt;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StringUtils;
import fr.amapj.service.engine.generator.odt.AmapjBulletDecorator;
import java.util.List;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.list.ListDecorator;

public class OdtGeneratorTool {
    TextDocument doc;
    private static final String TITRE1 = "<titre1>";
    private static final String TITRE2 = "<titre2>";
    private static final String CHAPITRE = "<chapitre>";
    private static final String TIRET = "-";

    public OdtGeneratorTool() {
        try {
            this.doc = TextDocument.newTextDocument();
            this.doc.getOfficeMasterStyles().getMasterPages();
        }
        catch (Exception e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public void addSautPage() {
    }

    public void addWikiContent(String wikiInput) {
        List<String> lines = StringUtils.asList(wikiInput);
        for (String line : lines) {
            this.processLine(line);
        }
    }

    private void processLine(String line) {
        if (line.startsWith(TITRE1)) {
            line = line.substring(TITRE1.length());
            this.addTitre1(line);
        } else if (line.startsWith(TITRE2)) {
            line = line.substring(TITRE1.length());
            this.addTitre2(line);
        } else if (line.startsWith(CHAPITRE)) {
            line = line.substring(CHAPITRE.length());
            this.addChapitre(line);
        } else if (line.startsWith(TIRET)) {
            line = line.substring(TIRET.length());
            this.addBullet(line);
        } else {
            this.addStandardText(line);
        }
    }

    public void addTitre1(String titre) {
        this.add(titre, StyleTypeDefinitions.HorizontalAlignmentType.CENTER, true, 14);
    }

    public void addTitre2(String titre) {
        this.add(titre, StyleTypeDefinitions.HorizontalAlignmentType.CENTER, false, 12);
    }

    public void addChapitre(String titre) {
        this.add(titre, StyleTypeDefinitions.HorizontalAlignmentType.LEFT, true, 12);
    }

    public void addStandardText(String titre) {
        this.add(titre, StyleTypeDefinitions.HorizontalAlignmentType.LEFT, false, 10);
    }

    public void addBullet(String titre) {
        org.odftoolkit.simple.text.list.List list = this.doc.addList((ListDecorator)new AmapjBulletDecorator((Document)this.doc));
        String[] items = new String[]{titre};
        list.addItems(items);
    }

    private Paragraph add(String content, StyleTypeDefinitions.HorizontalAlignmentType align, boolean bold, int fontSize) {
        Paragraph paragraph = this.doc.addParagraph(content);
        paragraph.setHorizontalAlignment(align);
        StyleTypeDefinitions.FontStyle fontStyle = bold ? StyleTypeDefinitions.FontStyle.BOLD : StyleTypeDefinitions.FontStyle.REGULAR;
        paragraph.setFont(new Font("Arial", fontStyle, (double)fontSize));
        return paragraph;
    }

    public TextDocument getDoc() {
        return this.doc;
    }
}

