/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.pdf;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.editionspe.AbstractEditionSpeJson;
import fr.amapj.model.models.editionspe.AbstractPdfEditionSpeJson;
import fr.amapj.service.engine.generator.pdf.AbstractPdfGenerator;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import fr.amapj.service.engine.generator.pdf.PdfHtmlUtils;

public abstract class TestablePdfGenerator
extends AbstractPdfGenerator {
    public AbstractPdfEditionSpeJson forTest;

    public abstract void fillPdfFile(RdbLink var1, PdfGeneratorTool var2, String var3);

    public abstract String readDataInTestMode(RdbLink var1, AbstractEditionSpeJson var2);

    public abstract AbstractPdfEditionSpeJson getEditionInNormalMode(RdbLink var1);

    public abstract String getFileNameStandard(RdbLink var1);

    public abstract String getNameToDisplayStandard(RdbLink var1);

    public TestablePdfGenerator(AbstractPdfEditionSpeJson forTest) {
        this.forTest = forTest;
    }

    @Override
    public final void fillPdfFile(RdbLink em, PdfGeneratorTool et) {
        Data d = this.computeEngagementAndHtml(em);
        String htmlContent = PdfHtmlUtils.extractBody(d.html);
        et.startDocument(d.engagement);
        if (d.error != null) {
            et.addContent(d.error);
            return;
        }
        this.fillPdfFile(em, et, htmlContent);
    }

    private Data computeEngagementAndHtml(RdbLink em) {
        if (this.forTest != null) {
            Data d = new Data();
            d.engagement = this.forTest;
            d.html = this.forTest.getText();
            d.error = this.readDataInTestMode(em, this.forTest);
            return d;
        }
        AbstractPdfEditionSpeJson engagement = this.getEditionInNormalMode(em);
        Data d = new Data();
        d.engagement = engagement;
        d.html = engagement.getText();
        return d;
    }

    @Override
    public final String getFileName(RdbLink em) {
        if (this.forTest != null) {
            return "test";
        }
        return this.getFileNameStandard(em);
    }

    @Override
    public final String getNameToDisplay(RdbLink em) {
        if (this.forTest != null) {
            return "test";
        }
        return this.getNameToDisplayStandard(em);
    }

    private class Data {
        public AbstractPdfEditionSpeJson engagement;
        public String html;
        public String error = null;

        private Data() {
        }
    }
}

