/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.sudo;

import fr.amapj.common.DateUtils;
import fr.amapj.service.engine.sudo.SudoInfo;
import fr.amapj.service.services.appinstance.SudoUtilisateurDTO;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class SudoManager {
    private static SudoManager mainInstance = new SudoManager();
    private List<SudoInfo> infos = new ArrayList<SudoInfo>();

    public static boolean authenticate(String sudo, Long utilisateurId, String nomInstance, String sessionKey) {
        return mainInstance.authenticateNS(sudo, utilisateurId, nomInstance, sessionKey);
    }

    public static String addSudoCredential(SudoUtilisateurDTO selected, String nomInstance, String sessionKey) {
        return mainInstance.addSudoCredentialNS(selected, nomInstance, sessionKey);
    }

    private String addSudoCredentialNS(SudoUtilisateurDTO selected, String nomInstance, String sessionKey) {
        String sudo = this.generateSudo();
        SudoInfo info = new SudoInfo();
        info.creationDate = DateUtils.getDate();
        info.sudoKey = sudo;
        info.utilisateurId = selected.id;
        info.nomInstance = nomInstance;
        info.sessionKey = sessionKey;
        this.infos.add(info);
        return sudo;
    }

    private String generateSudo() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[16];
            random.nextBytes(salt);
            Base64 coder = new Base64(true);
            String str = coder.encodeAsString(salt);
            str = str.replace('\r', '0');
            str = str.replace('\n', '0');
            return str;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Erreur inattendue", e);
        }
    }

    private boolean authenticateNS(String sudo, Long utilisateurId, String nomInstance, String sessionKey) {
        this.suppressOldEntries();
        for (SudoInfo info : this.infos) {
            if (!info.sudoKey.equals(sudo) || !info.utilisateurId.equals(utilisateurId) || !info.nomInstance.equals(nomInstance) || !info.sessionKey.equals(sessionKey)) continue;
            return true;
        }
        return false;
    }

    private void suppressOldEntries() {
        Date ref = DateUtils.addMinute(DateUtils.getDate(), -1);
        ArrayList<SudoInfo> toSuppress = new ArrayList<SudoInfo>();
        for (SudoInfo info : this.infos) {
            if (!info.creationDate.before(ref)) continue;
            toSuppress.add(info);
        }
        this.infos.removeAll(toSuppress);
    }
}

