/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.tools;

import fr.amapj.common.GenericUtils;
import fr.amapj.common.ObjectUtils;
import java.util.ArrayList;
import java.util.List;

public class DtoToDb {
    public static <DB, DTO, KEY> ListDiff<DB, DTO, KEY> diffList(List<DB> dbList, List<DTO> dtoList, GenericUtils.GetFieldTyped<DB, KEY> keyDb, GenericUtils.GetFieldTyped<DTO, KEY> keyDto) {
        KEY val;
        ListDiff res = new ListDiff();
        res.toAdd = new ArrayList();
        res.toSuppress = new ArrayList();
        res.toUpdate = new ArrayList();
        for (DB t : dbList) {
            val = keyDb.getField(t);
            if (!DtoToDb.isNotIn(dtoList, val, keyDto)) continue;
            res.toSuppress.add(t);
        }
        int i = 0;
        while (i < dtoList.size()) {
            DTO t = dtoList.get(i);
            val = keyDto.getField(t);
            if (DtoToDb.isNotIn(dbList, val, keyDb)) {
                ElementToAdd element = new ElementToAdd();
                element.dto = t;
                element.index = i;
                res.toAdd.add(element);
            }
            ++i;
        }
        for (DB t : dbList) {
            val = keyDb.getField(t);
            ElementToUpdate match = DtoToDb.find(dtoList, val, keyDto);
            if (match == null) continue;
            match.db = t;
            res.toUpdate.add(match);
        }
        return res;
    }

    private static <T, V> boolean isNotIn(List<T> ls, V val1, GenericUtils.GetFieldTyped<T, V> compare) {
        for (T t : ls) {
            V val2 = compare.getField(t);
            if (!ObjectUtils.equals(val1, val2)) continue;
            return false;
        }
        return true;
    }

    private static <OLD, NEW, KEY> ElementToUpdate<OLD, NEW> find(List<NEW> dtos, KEY key, GenericUtils.GetFieldTyped<NEW, KEY> compare) {
        int i = 0;
        while (i < dtos.size()) {
            NEW dto = dtos.get(i);
            KEY key2 = compare.getField(dto);
            if (ObjectUtils.equals(key, key2)) {
                ElementToUpdate el = new ElementToUpdate();
                el.dto = dto;
                el.index = i;
                return el;
            }
            ++i;
        }
        return null;
    }

    public static class ElementToAdd<DTO> {
        public DTO dto;
        public int index;
    }

    public static class ElementToUpdate<DB, DTO> {
        public DB db;
        public DTO dto;
        public int index;
    }

    public static class ListDiff<DB, DTO, KEY> {
        public List<ElementToAdd<DTO>> toAdd;
        public List<DB> toSuppress;
        public List<ElementToUpdate<DB, DTO>> toUpdate;
    }
}

