/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.access;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.RoleAdmin;
import fr.amapj.model.models.fichierbase.RoleTresorier;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.access.AdminTresorierDTO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class AccessManagementService {
    public List<RoleList> getUserRole(Utilisateur u, RdbLink em) {
        ArrayList<RoleList> res = new ArrayList<RoleList>();
        if (this.isMaster(em, u)) {
            res.add(RoleList.MASTER);
            res.add(RoleList.ADMIN);
            res.add(RoleList.TRESORIER);
            return res;
        }
        if (this.isAdmin(em, u)) {
            res.add(RoleList.ADMIN);
            res.add(RoleList.TRESORIER);
            res.add(RoleList.PRODUCTEUR);
            res.add(RoleList.REFERENT);
            res.add(RoleList.ADHERENT);
            return res;
        }
        if (this.isTresorier(em, u)) {
            res.add(RoleList.TRESORIER);
            res.add(RoleList.PRODUCTEUR);
            res.add(RoleList.REFERENT);
            res.add(RoleList.ADHERENT);
            return res;
        }
        if (this.isReferent(em, u)) {
            res.add(RoleList.REFERENT);
            res.add(RoleList.PRODUCTEUR);
            res.add(RoleList.ADHERENT);
            return res;
        }
        if (this.isProducteur(em, u)) {
            res.add(RoleList.PRODUCTEUR);
            res.add(RoleList.ADHERENT);
            return res;
        }
        res.add(RoleList.ADHERENT);
        return res;
    }

    public String getRoleAsString(RdbLink em, Utilisateur u) {
        if (this.isMaster(em, u)) {
            return "MASTER";
        }
        if (this.isAdmin(em, u)) {
            return "ADMIN";
        }
        if (this.isTresorier(em, u)) {
            return "TRESORIER";
        }
        boolean ref = this.isReferent(em, u);
        boolean prod = this.isProducteur(em, u);
        if (ref && prod) {
            return "REFERENT et PRODUCTEUR";
        }
        if (ref) {
            return "REFERENT";
        }
        if (prod) {
            return "PRODUCTEUR";
        }
        return "ADHERENT";
    }

    private boolean isMaster(RdbLink em, Utilisateur u) {
        Query q = em.createQuery("select r.id from RoleMaster r  WHERE r.utilisateur=:u");
        q.setParameter("u", (Object)u);
        return q.getResultList().size() >= 1;
    }

    private boolean isAdmin(RdbLink em, Utilisateur u) {
        Query q = em.createQuery("select r.id from RoleAdmin r  WHERE r.utilisateur=:u");
        q.setParameter("u", (Object)u);
        return q.getResultList().size() >= 1;
    }

    private boolean isTresorier(RdbLink em, Utilisateur u) {
        Query q = em.createQuery("select r.id from RoleTresorier r  WHERE r.utilisateur=:u");
        q.setParameter("u", (Object)u);
        return q.getResultList().size() >= 1;
    }

    private boolean isReferent(RdbLink em, Utilisateur u) {
        Query q = em.createQuery("select r.id from ProducteurReferent r  WHERE r.referent=:u");
        q.setParameter("u", (Object)u);
        return q.getResultList().size() >= 1;
    }

    private boolean isProducteur(RdbLink em, Utilisateur u) {
        Query q = em.createQuery("select r.id from ProducteurUtilisateur r  WHERE r.utilisateur=:u");
        q.setParameter("u", (Object)u);
        return q.getResultList().size() >= 1;
    }

    @DbRead
    public List<Producteur> getAccessLivraisonProducteur(List<RoleList> roles, Long idUtilisateur, boolean actifOnly) {
        try {
            ArrayList<Producteur> arrayList;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur user = em.find(Utilisateur.class, idUtilisateur);
            ArrayList<Producteur> res = new ArrayList<Producteur>();
            if (roles.contains((Object)RoleList.ADMIN) || roles.contains((Object)RoleList.TRESORIER)) {
                TypedQuery<Producteur> q;
                if (actifOnly) {
                    q = em.createQuery("select p from Producteur p WHERE p.etat = :etat order by p.nom", Producteur.class);
                    q.setParameter("etat", (Object)EtatProducteur.ACTIF);
                } else {
                    q = em.createQuery("select p from Producteur p order by p.nom", Producteur.class);
                }
                res.addAll(q.getResultList());
                arrayList = res;
            } else {
                TypedQuery<Producteur> q;
                if (actifOnly) {
                    q = em.createQuery("select distinct(c.producteur) from ProducteurUtilisateur c WHERE c.utilisateur=:u AND c.producteur.etat=:etat order by c.producteur.nom", Producteur.class);
                    q.setParameter("etat", (Object)EtatProducteur.ACTIF);
                    q.setParameter("u", (Object)user);
                } else {
                    q = em.createQuery("select distinct(c.producteur) from ProducteurUtilisateur c WHERE c.utilisateur=:u order by c.producteur.nom", Producteur.class);
                    q.setParameter("u", (Object)user);
                }
                res.addAll(q.getResultList());
                if (actifOnly) {
                    q = em.createQuery("select distinct(c.producteur) from ProducteurReferent c WHERE c.referent=:u AND c.producteur.etat=:etat order by c.producteur.nom", Producteur.class);
                    q.setParameter("etat", (Object)EtatProducteur.ACTIF);
                    q.setParameter("u", (Object)user);
                } else {
                    q = em.createQuery("select distinct(c.producteur) from ProducteurReferent c WHERE c.referent=:u order by c.producteur.nom", Producteur.class);
                    q.setParameter("u", (Object)user);
                }
                res.addAll(q.getResultList());
                arrayList = res;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public boolean isAllowToSign(Long idUtilisateur, Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select count(pu) from ProducteurUtilisateur pu WHERE pu.utilisateur.id=:idUtilisateur AND pu.producteur.id=:idProducteur");
            em.setParameter("idUtilisateur", idUtilisateur);
            em.setParameter("idProducteur", idProducteur);
            boolean bl = em.result().singleInt() > 0;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<AdminTresorierDTO> getAllAdmin() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select r from RoleAdmin r");
            List<AdminTresorierDTO> list = DbToDto.transform(q, r -> this.loadAdminDTO((RoleAdmin)r));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private AdminTresorierDTO loadAdminDTO(RoleAdmin roleAdmin) {
        AdminTresorierDTO dto = new AdminTresorierDTO();
        dto.id = roleAdmin.getId();
        dto.utilisateurId = roleAdmin.utilisateur.getId();
        dto.nom = roleAdmin.utilisateur.nom;
        dto.prenom = roleAdmin.utilisateur.prenom;
        return dto;
    }

    @DbWrite
    public void createAdmin(AdminTresorierDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RoleAdmin p = new RoleAdmin();
            p.utilisateur = em.find(Utilisateur.class, dto.utilisateurId);
            em.persist(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteAdmin(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RoleAdmin p = em.find(RoleAdmin.class, id);
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<AdminTresorierDTO> getAllTresorier() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select r from RoleTresorier r");
            List<AdminTresorierDTO> list = DbToDto.transform(q, r -> this.loadTresorierDTO((RoleTresorier)r));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private AdminTresorierDTO loadTresorierDTO(RoleTresorier r) {
        AdminTresorierDTO dto = new AdminTresorierDTO();
        dto.id = r.getId();
        dto.utilisateurId = r.utilisateur.getId();
        dto.nom = r.utilisateur.nom;
        dto.prenom = r.utilisateur.prenom;
        return dto;
    }

    @DbWrite
    public void createTresorier(AdminTresorierDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RoleTresorier p = new RoleTresorier();
            p.utilisateur = em.find(Utilisateur.class, dto.utilisateurId);
            em.persist(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteTresorier(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RoleTresorier p = em.find(RoleTresorier.class, id);
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String canBeDeleted(Long idUtilisateur) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            if (this.isAdmin(em, u)) {
                string = "L'utilisateur est ADMIN";
            } else if (this.isTresorier(em, u)) {
                string = "L'utilisateur est TRESORIER";
            } else {
                TypedQuery<Producteur> q = em.createQuery("select r.producteur from ProducteurReferent r  WHERE r.referent=:u", Producteur.class);
                q.setParameter("u", (Object)u);
                List ps = q.getResultList();
                if (ps.size() >= 1) {
                    string = "L'utilisateur est marqu\u00e9 comme REFERENT pour le producteur " + ((Producteur)ps.get((int)0)).nom;
                } else {
                    q = em.createQuery("select r.producteur from ProducteurUtilisateur r  WHERE r.utilisateur=:u", Producteur.class);
                    q.setParameter("u", (Object)u);
                    ps = q.getResultList();
                    string = ps.size() >= 1 ? "L'utilisateur est marqu\u00e9 comme PRODUCTEUR pour le producteur " + ((Producteur)ps.get((int)0)).nom : null;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public String canBeArchive(Long idUtilisateur) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            if (this.isAdmin(em, u)) {
                string = "L'utilisateur est ADMIN";
            } else if (this.isTresorier(em, u)) {
                string = "L'utilisateur est TRESORIER";
            } else {
                TypedQuery<Producteur> q = em.createQuery("select r.producteur from ProducteurReferent r  WHERE r.referent=:u AND r.producteur.etat = :etat", Producteur.class);
                q.setParameter("u", (Object)u);
                q.setParameter("etat", (Object)EtatProducteur.ACTIF);
                List ps = q.getResultList();
                if (ps.size() >= 1) {
                    string = "L'utilisateur est marqu\u00e9 comme REFERENT pour le producteur " + ((Producteur)ps.get((int)0)).nom;
                } else {
                    q = em.createQuery("select r.producteur from ProducteurUtilisateur r  WHERE r.utilisateur=:u AND r.producteur.etat = :etat", Producteur.class);
                    q.setParameter("u", (Object)u);
                    q.setParameter("etat", (Object)EtatProducteur.ACTIF);
                    ps = q.getResultList();
                    string = ps.size() >= 1 ? "L'utilisateur est marqu\u00e9 comme PRODUCTEUR pour le producteur " + ((Producteur)ps.get((int)0)).nom : null;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<String> detailDesRoles(Long idUtilisateur) {
        try {
            String str;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            ArrayList<String> res = new ArrayList<String>();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            if (this.isAdmin(em, u)) {
                res.add("Cet utilisateur est ADMIN");
            }
            if (this.isTresorier(em, u)) {
                res.add("Cet utilisateur est TRESORIER");
            }
            TypedQuery<Producteur> q = em.createQuery("select r.producteur from ProducteurReferent r  WHERE r.referent=:u", Producteur.class);
            q.setParameter("u", (Object)u);
            for (Producteur producteur : q.getResultList()) {
                str = producteur.etat == EtatProducteur.ACTIF ? "" : " (Producteur archiv\u00e9)";
                res.add("Cet utilisateur est REFERENT pour le producteur " + producteur.nom + str);
            }
            q = em.createQuery("select r.producteur from ProducteurUtilisateur r  WHERE r.utilisateur=:u", Producteur.class);
            q.setParameter("u", (Object)u);
            for (Producteur producteur : q.getResultList()) {
                str = producteur.etat == EtatProducteur.ACTIF ? "" : " (Producteur archiv\u00e9)";
                res.add("Cet utilisateur est PRODUCTEUR pour le producteur " + producteur.nom + str);
            }
            ArrayList<String> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

