/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.advanced.patch;

import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.web.WebPage;
import fr.amapj.service.engine.objectstorage.basestorage.remote.RemoteBaseObjectStorageService;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatchService {
    private static final Logger logger = LogManager.getLogger();

    public String applyPatchV042() {
        StringBuffer str = new StringBuffer();
        RemoteBaseObjectStorageService ross = new RemoteBaseObjectStorageService(AppConfiguration.getConf());
        SpecificDbUtils.executeInAllDb(() -> this.patch(str, ross), false);
        return str.toString();
    }

    @DbRead
    private Void patch(StringBuffer str, RemoteBaseObjectStorageService ross) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            String dbName = DbManager.get().getCurrentDb().getDbName();
            em.createQuery("select p from WebPage p");
            List<WebPage> ws = em.result().list(WebPage.class);
            this.msg(str, "Pour la base :" + dbName + " il y a " + ws.size() + " webpage \u00e0 transf\u00e9rer");
            for (WebPage w : ws) {
                NewTransaction.write(em2 -> this.transferWebPage((RdbLink)em2, webPage.id, str, ross));
            }
            str.append("ok pour " + dbName + "<br/>");
            Void void_ = null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return void_;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void transferWebPage(RdbLink em, Long id, StringBuffer str, RemoteBaseObjectStorageService ross) {
        this.msg(str, "D\u00e9but de transfert WebPage id=" + id);
        WebPage webPage = em.find(WebPage.class, id);
        if (webPage.getHtml() != null) {
            this.msg(str, "WebPage id=" + id + " ignor\u00e9e, transfert d\u00e9j\u00e0 r\u00e9alis\u00e9");
            return;
        }
        byte[] html = ross.onlyForPatchLoadWebPageAsHtml(id);
        webPage.setHtml(em, html);
        this.msg(str, "WebPage id=" + id + " transfert effectu\u00e9 avec succ\u00e9s size html = " + html.length);
    }

    private void msg(StringBuffer str, String msg) {
        str.append(String.valueOf(msg.replaceAll("\n", "<br/>")) + "<br/>");
        logger.info(msg);
    }
}

