/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.appinstance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.saas.AppInstance;
import fr.amapj.model.models.saas.StateOnStart;
import fr.amapj.service.services.appinstance.AdminTresorierDataDTO;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppState;
import fr.amapj.service.services.appinstance.SchemaDbDTO;
import fr.amapj.service.services.appinstance.SqlRequestDTO;
import fr.amapj.service.services.appinstance.SudoUtilisateurDTO;
import fr.amapj.service.services.logview.LogViewService;
import fr.amapj.service.services.logview.StatInstanceDTO;
import fr.amapj.service.services.mailer.MailerCounter;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.suiviacces.ConnectedUserDTO;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.ui.AppConfiguration;
import fr.amapj.view.views.appinstance.BackupImporter;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AppInstanceService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public List<AppInstanceDTO> getAllInstances(boolean withMaster) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<AppInstanceDTO> res = new ArrayList<AppInstanceDTO>();
            Query q = em.createQuery("select a from AppInstance a ORDER BY a.nomInstance");
            List ps = q.getResultList();
            List<ConnectedUserDTO> connected = SessionManager.getAllConnectedUser();
            for (AppInstance p : ps) {
                AppInstanceDTO dto = this.createAppInstanceDto(connected, p);
                res.add(dto);
            }
            if (withMaster) {
                AppInstanceDTO master = AppConfiguration.getConf().getMasterConf();
                this.addInfo(master, connected);
                res.add(master);
            }
            ArrayList<AppInstanceDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public AppInstanceDTO createAppInstanceDto(List<ConnectedUserDTO> connected, AppInstance a) {
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.id = a.getId();
        dto.nomInstance = a.nomInstance;
        dto.dateCreation = a.dateCreation;
        dto.dbUserName = a.dbUserName;
        dto.dbPassword = a.dbPassword;
        dto.stateOnStart = a.stateOnStart;
        this.addInfo(dto, connected);
        return dto;
    }

    private void addInfo(AppInstanceDTO dto, List<ConnectedUserDTO> connected) {
        dto.state = this.getState(dto.getNomInstance());
        dto.nbUtilisateurs = this.getNbUtilisateurs(connected, dto.getNomInstance());
        dto.nbMails = MailerCounter.getNbMails(dto.getNomInstance());
    }

    private AppState getState(String nomInstance) {
        DataBaseInfo dataBaseInfo = DbManager.get().findDataBaseFromName(nomInstance);
        if (dataBaseInfo == null) {
            return AppState.OFF;
        }
        return dataBaseInfo.getState();
    }

    private int getNbUtilisateurs(List<ConnectedUserDTO> connected, String nomInstance) {
        int res = 0;
        for (ConnectedUserDTO connectedUserDTO : connected) {
            if (!connectedUserDTO.isLogged || !StringUtils.equals(connectedUserDTO.dbName, nomInstance)) continue;
            ++res;
        }
        return res;
    }

    public void create(AppInstanceDTO appInstanceDTO) {
        DbManager.get().createDataBase(appInstanceDTO);
        NewTransaction.writeInMaster(em -> {
            AppInstance a = new AppInstance();
            a.nomInstance = appInstanceDTO.nomInstance;
            a.dateCreation = DateUtils.getDate();
            a.dbUserName = appInstanceDTO.dbUserName;
            a.dbPassword = appInstanceDTO.dbPassword;
            a.stateOnStart = appInstanceDTO.stateOnStart;
            em.persist(a);
        });
    }

    public void restoreFromBackup(AppInstanceDTO appInstanceDTO, BackupImporter backupImporter) {
    }

    @DbWrite
    public void delete(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            AppInstance a = em.find(AppInstance.class, id);
            em.remove(a);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public List<SudoUtilisateurDTO> getSudoUtilisateurDto(AppInstanceDTO dto) {
        return SpecificDbUtils.executeInSpecificDb(dto.nomInstance, () -> this.getSudoUtilisateurDto());
    }

    public List<SudoUtilisateurDTO> getSudoUtilisateurDto() {
        ArrayList<SudoUtilisateurDTO> res = new ArrayList<SudoUtilisateurDTO>();
        ParametresDTO param = new ParametresService().getParametres();
        List<UtilisateurDTO> utilisateurDTOs = new UtilisateurService().getAllUtilisateurs(null);
        for (UtilisateurDTO utilisateur : utilisateurDTOs) {
            SudoUtilisateurDTO dto = new SudoUtilisateurDTO();
            dto.id = utilisateur.getId();
            dto.nom = utilisateur.getNom();
            dto.prenom = utilisateur.getPrenom();
            dto.roles = utilisateur.roles;
            dto.baseUrl = param.getUrl();
            dto.emailUrl = "?username=" + utilisateur.getEmail();
            res.add(dto);
        }
        CollectionUtils.sort(res, e -> !e.roles.contains("ADMIN"), e -> !e.roles.contains("TRESORIER"), e -> e.nom, e -> e.prenom);
        return res;
    }

    public void executeSqlRequest(SqlRequestDTO selected, List<AppInstanceDTO> appInstanceDTOs) {
        boolean ddlRequest = selected.sqlType == SqlRequestDTO.SqlType.UPDATE_OR_INSERT_OR_DDL;
        selected.success = false;
        for (AppInstanceDTO appInstanceDTO : appInstanceDTOs) {
            logger.info("Execution des requetes sur la base " + appInstanceDTO.nomInstance);
            SqlRequestDTO.DataBaseResponseDTO dataBaseResponseDTO = new SqlRequestDTO.DataBaseResponseDTO();
            dataBaseResponseDTO.success = false;
            dataBaseResponseDTO.dbName = appInstanceDTO.nomInstance;
            selected.responses.add(dataBaseResponseDTO);
            int index = 1;
            for (String request : selected.verifiedRequests) {
                SqlRequestDTO.ResponseDTO res = this.executeOneSqlRequest(request, appInstanceDTO, index, ddlRequest);
                dataBaseResponseDTO.responses.add(res);
                if (!res.success) {
                    return;
                }
                ++index;
            }
            dataBaseResponseDTO.success = true;
        }
        selected.success = true;
    }

    private SqlRequestDTO.ResponseDTO executeOneSqlRequest(String request, AppInstanceDTO dto, int index, boolean ddlRequest) {
        SqlRequestDTO.ResponseDTO res = new SqlRequestDTO.ResponseDTO();
        res.index = index;
        res.sqlRequest = request;
        try {
            if (ddlRequest) {
                res.nbModifiedLines = DbManager.get().executeUpdateSqlCommand(request, dto);
            } else {
                res.sqlResultSet = DbManager.get().executeQuerySqlCommand(request, dto);
            }
            res.sqlResponse = "OK";
            res.success = true;
        }
        catch (SQLException e) {
            res.sqlResponse = "Erreur : " + e.getMessage();
            res.success = false;
        }
        return res;
    }

    public List<String> saveInstance(List<AppInstanceDTO> appInstanceDTOs) {
        ArrayList<String> res = new ArrayList<String>();
        String backupDir = AppConfiguration.getConf().getBackupDirectory();
        if (backupDir == null) {
            throw new RuntimeException("Le r\u00e9pertoire de stockage des sauvegardes n'est pas d\u00e9fini");
        }
        for (AppInstanceDTO appInstanceDTO : appInstanceDTOs) {
            String msg = this.saveInstance(appInstanceDTO, backupDir);
            res.add(msg);
        }
        return res;
    }

    private String saveInstance(AppInstanceDTO appInstanceDTO, String backupDir) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String fileName = String.valueOf(backupDir) + "/" + appInstanceDTO.nomInstance + "_" + df.format(DateUtils.getDate()) + ".tar.gz";
        String request = "BACKUP DATABASE TO '" + fileName + "' BLOCKING";
        SqlRequestDTO.ResponseDTO res = this.executeOneSqlRequest(request, appInstanceDTO, 0, true);
        if (!res.success) {
            return "Erreur pour " + appInstanceDTO.nomInstance + ": " + res.sqlResponse;
        }
        File file = new File(fileName);
        if (!file.canRead()) {
            return "Erreur pour " + appInstanceDTO.nomInstance + ": le fichier n'est pas trouv\u00e9";
        }
        return "Succ\u00e8s pour " + appInstanceDTO.nomInstance;
    }

    public String getAllMails() {
        StringBuffer str = new StringBuffer();
        SpecificDbUtils.executeInAllDb(() -> this.appendMails(str), false);
        return str.toString();
    }

    @DbRead
    private Void appendMails(StringBuffer str) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            String dbName = DbManager.get().getCurrentDb().getDbName();
            Query q = em.createQuery("select distinct(u) from Utilisateur u  where u.id in (select a.utilisateur.id from RoleAdmin a) and u.etatUtilisateur = :etat order by u.nom,u.prenom");
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            List us = q.getResultList();
            str.append(CollectionUtils.asStringFinalSep(us, ",", t -> "\"" + dbName + "\" <" + t.email + ">"));
            Void void_ = null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return void_;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public String getStatInfo() {
        AdminTresorierDataDTO data = new AdminTresorierDataDTO();
        data.extractionDate = new Date();
        String dbNameMaster = DbManager.get().getMasterDb().getDbName();
        List statAccess = SpecificDbUtils.executeInSpecificDb(dbNameMaster, () -> new LogViewService().getStatInstance());
        SpecificDbUtils.executeInAllDb(() -> this.appendStatInfo(data, statAccess), false);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)data);
    }

    @DbRead
    private Void appendStatInfo(AdminTresorierDataDTO data, List<StatInstanceDTO> statAccess) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            String dbName = DbManager.get().getCurrentDb().getDbName();
            AdminTresorierDataDTO.InstanceDTO stat = new AdminTresorierDataDTO.InstanceDTO();
            stat.code = dbName;
            stat.nom = new ParametresService().getParametres().nomAmap;
            stat.nbAccessLastMonth = statAccess.stream().filter(e -> e.nomInstance.equals(dbName)).findFirst().map(e -> e.detail[0].nbAccess).orElse(0);
            TypedQuery<Utilisateur> q = em.createQuery("select distinct(u) from Utilisateur u  where u.id in (select a.utilisateur.id from RoleAdmin a) and u.etatUtilisateur = :etat order by u.nom,u.prenom", Utilisateur.class);
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            stat.admins = q.getResultList().stream().map(e -> new AdminTresorierDataDTO.ContactDTO(e.nom, e.prenom, e.email)).collect(Collectors.toList());
            q = em.createQuery("select distinct(u) from Utilisateur u  where u.id in (select a.utilisateur.id from RoleTresorier a) and u.etatUtilisateur = :etat order by u.nom,u.prenom", Utilisateur.class);
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            stat.tresoriers = q.getResultList().stream().map(e -> new AdminTresorierDataDTO.ContactDTO(e.nom, e.prenom, e.email)).collect(Collectors.toList());
            data.instances.add(stat);
            Void void_ = null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return void_;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public String getSchemaAllBases(boolean computeSize) {
        SchemaDbDTO data = new SchemaDbDTO();
        SpecificDbUtils.executeInAllDb(() -> this.appendSchema(data, computeSize), false);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)data);
    }

    @DbRead
    private Void appendSchema(SchemaDbDTO data, boolean computeSize) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            String dbName = DbManager.get().getCurrentDb().getDbName();
            SchemaDbDTO.OneSchemaDTO oneSchemaDTO = new SchemaDbDTO.OneSchemaDTO();
            oneSchemaDTO.code = dbName;
            data.instances.add(oneSchemaDTO);
            Query q = em.createNativeQuery("SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DTD_IDENTIFIER FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='PUBLIC' ORDER BY TABLE_NAME, COLUMN_NAME");
            List ds = q.getResultList();
            for (Object[] d : ds) {
                long size = 0L;
                if (computeSize) {
                    size = this.computeSize(em, "" + d[0], "" + d[1], "" + d[3]);
                }
                SchemaDbDTO.DbColumnDTO col = new SchemaDbDTO.DbColumnDTO("" + d[0], "" + d[1], "" + d[2], "" + d[3], size);
                oneSchemaDTO.cols.add(col);
            }
            q = em.createNativeQuery("select FKTABLE_NAME,FKCOLUMN_NAME,PKTABLE_NAME,PKCOLUMN_NAME,FK_NAME from INFORMATION_SCHEMA.SYSTEM_CROSSREFERENCE  order by FKTABLE_NAME,FKCOLUMN_NAME,FK_NAME");
            ds = q.getResultList();
            for (Object[] d : ds) {
                SchemaDbDTO.DbForeignKeyDTO col = new SchemaDbDTO.DbForeignKeyDTO("" + d[0], "" + d[1], "" + d[2], "" + d[3], "" + d[4]);
                oneSchemaDTO.foreignKeys.add(col);
            }
            q = em.createNativeQuery("select CONSTRAINT_NAME,TABLE_NAME,column_name from information_schema.constraint_column_usage where CONSTRAINT_NAME  in (SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE='UNIQUE' and TABLE_SCHEMA='PUBLIC')  order by CONSTRAINT_NAME,COLUMN_NAME");
            ds = q.getResultList();
            for (Object[] d : ds) {
                SchemaDbDTO.DbUniqKeyDTO col = new SchemaDbDTO.DbUniqKeyDTO("" + d[0], "" + d[1], "" + d[2]);
                oneSchemaDTO.uniqKeys.add(col);
            }
            Void void_ = null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return void_;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private long computeSize(RdbLink em, String tableName, String columnName, String dtdIdentifier) {
        if (dtdIdentifier.startsWith("VARCHAR")) {
            Query q = em.createNativeQuery("SELECT SUM(LENGTH(" + columnName + ")) FROM " + tableName);
            return SQLUtils.count(q);
        }
        int fieldSize = this.computeFieldSize(dtdIdentifier);
        Query q = em.createNativeQuery("SELECT COUNT(" + columnName + ") FROM " + tableName);
        return SQLUtils.count(q) * (long)fieldSize;
    }

    private int computeFieldSize(String dtdIdentifier) {
        if (dtdIdentifier.equals("BIGINT")) {
            return 8;
        }
        if (dtdIdentifier.equals("INTEGER")) {
            return 4;
        }
        if (dtdIdentifier.equals("BOOLEAN")) {
            return 1;
        }
        if (dtdIdentifier.equals("DATE")) {
            return 6;
        }
        if (dtdIdentifier.equals("TIMESTAMP")) {
            return 10;
        }
        if (dtdIdentifier.equals("NUMERIC(38)")) {
            return 10;
        }
        throw new AmapjRuntimeException(dtdIdentifier);
    }

    @DbWrite
    public void setDbStateOnStart(List<AppInstanceDTO> dtos, StateOnStart stateOnStart) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            for (AppInstanceDTO appInstanceDTO : dtos) {
                AppInstance app = em.find(AppInstance.class, appInstanceDTO.id);
                app.stateOnStart = stateOnStart;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

