/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.appinstance;

import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.saas.StateOnStart;
import fr.amapj.service.engine.deamons.DeamonsUtils;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.service.services.appinstance.AppState;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DemarrageAppInstanceService {
    private static final Logger logger = LogManager.getLogger();

    public void startAllDbs() {
        DeamonsUtils.executeAsDeamon(this.getClass(), e -> this.startAllDatabase());
    }

    @DbRead
    public void startAllDatabase() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            DbManager dbManager = DbManager.get();
            AppInstanceService service = new AppInstanceService();
            List<AppInstanceDTO> dtos = service.getAllInstances(false);
            for (AppInstanceDTO dto : dtos) {
                this.performStart(dbManager, dto);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void performStart(DbManager dbManager, AppInstanceDTO dto) {
        try {
            logger.info("Traitement de la base " + dto.nomInstance + " StateOnStart =" + (Object)((Object)dto.stateOnStart));
            AppState appState = dto.stateOnStart == StateOnStart.ON_START_BE_ON ? AppState.ON : AppState.OFF;
            dbManager.addDataBase(dto, appState);
        }
        catch (Exception e) {
            logger.info("Erreur sur la base " + dto.nomInstance, (Throwable)e);
        }
    }
}

