/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.archivage;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.archivage.tools.ArchivableState;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ArchivageUtilisateurService {
    public String computeArchivageLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable d'archiver un utilisateur qui remplit les conditions suivantes : <ul><li>tous les paiements ont \u00e9t\u00e9 finalis\u00e9s</li><li>la date de derni\u00e8re livraison est plus vieille que " + param.archivageUtilisateur + " jours</li>" + "<li>la date de fin de sa derni\u00e8re adh\u00e9sion est plus vieille que " + param.archivageUtilisateur + " jours</li>" + "<li>cet utilisateur n'a pas le role de PRODUCTEUR ou REFERENT (sur un producteur actif)</li>" + "<li>cet utilisateur n'a pas le role de TRESORIER ou ADMIN</li>" + "<li>cet utilisateur n'est pas inscrit sur une permanence dans le futur</li>" + "<li>la date de cr\u00e9ation de cet utilisateur est plus vieille que 60 jours</li>" + "</ul><br/>";
        return str;
    }

    @DbRead
    public ArchivableState computeArchivageState(Long idUtilisateur, ParametresArchivageDTO param) {
        try {
            String str;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArchivableState res = new ArchivableState();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            if (u.etatUtilisateur != EtatUtilisateur.ACTIF) {
                res.nonArchivables.add("L'utilisateur est \u00e0 l'\u00e9tat " + (Object)((Object)u.etatUtilisateur) + ", il doit \u00eatre \u00e0 l'\u00e9tat ACTIF pour pouvoir \u00eatre archiv\u00e9.");
            }
            em.createQuery("select p from Paiement p WHERE p.contrat.utilisateur.id=:id AND p.etat!=:etat");
            em.setParameter("id", idUtilisateur);
            em.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
            List<Paiement> paiements = em.result().list(Paiement.class);
            if (paiements.size() != 0) {
                String lib = paiements.stream().map(e -> this.formatPaiement((Paiement)e)).collect(Collectors.joining("<br/>"));
                res.reserveMajeures.add("Il existe  " + paiements.size() + " ch\u00e8ques de cet utilisateur qui n'ont pas \u00e9t\u00e9 remis \u00e0 l'AMAP ou au producteur : <br/>" + lib);
            }
            Date ref = DateUtils.getDateWithNoTime();
            ref = DateUtils.addDays(ref, -param.archivageUtilisateur);
            em.createQuery("select count(distinct(c.modeleContratDate)) from ContratCell c WHERE c.modeleContratDate.dateLiv>=:d AND c.contrat.utilisateur.id=:id");
            em.setParameter("d", ref);
            em.setParameter("id", idUtilisateur);
            int nbLiv = em.result().singleInt();
            if (nbLiv != 0) {
                res.reserveMineures.add("Il existe " + nbLiv + " livraisons de moins de " + param.archivageUtilisateur + " jours.");
            }
            em.createQuery("select count(c) from PeriodeCotisationUtilisateur c WHERE c.periodeCotisation.dateFin>=:d AND c.utilisateur.id=:id");
            em.setParameter("d", ref);
            em.setParameter("id", idUtilisateur);
            if (em.result().singleInt() != 0) {
                res.reserveMineures.add("La date de fin de sa derni\u00e8re adh\u00e9sion est r\u00e9cente (moins de " + param.archivageUtilisateur + " jours).");
            }
            if ((str = new AccessManagementService().canBeArchive(idUtilisateur)) != null) {
                res.nonArchivables.add(str);
            }
            if ((str = this.checkPermanenceFuture(em, idUtilisateur)) != null) {
                res.reserveMajeures.add(str);
            }
            if ((str = this.checkDateCreation(em, u, 90)) != null) {
                res.reserveMajeures.add(str);
            }
            ArchivableState archivableState = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return archivableState;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String formatPaiement(Paiement e) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        return "Contrat :" + e.modeleContratDatePaiement.modeleContrat.nom + " Date :" + df.format(e.modeleContratDatePaiement.datePaiement) + " Montant : " + new CurrencyTextFieldConverter().convertToString(e.montant) + " \u20ac Etat du paiement=" + (Object)((Object)e.etat);
    }

    public List<UtilisateurDTO> getAllUtilisateursArchivables(ParametresArchivageDTO param) {
        List<UtilisateurDTO> alls = new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.ACTIF);
        ArrayList<UtilisateurDTO> res = new ArrayList<UtilisateurDTO>();
        for (UtilisateurDTO a : alls) {
            ArchivableState state = this.computeArchivageState(a.id, param);
            if (state.getStatus() != ArchivableState.AStatus.OUI_SANS_RESERVE) continue;
            res.add(a);
        }
        res.sort(Comparator.comparing(e -> String.valueOf(e.nom) + " " + e.prenom));
        return res;
    }

    public String computeSuppressionLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable de supprimer un utilisateur archiv\u00e9 qui remplit les conditions suivantes : <ul><li>tous les contrats de cet utilisateur ont \u00e9t\u00e9 supprim\u00e9s</li><li>cet utilisateur n'est pas inscrit sur une p\u00e9riode de cotisation</li><li>cet utilisateur n'a pas le role de PRODUCTEUR ou REFERENT ou TRESORIER ou ADMIN</li><li>cet utilisateur n'est pas inscrit sur une permanence dans le futur</li><li>la date de cr\u00e9ation de cet utilisateur est plus vieille que 90 jours</li></ul><br/></ul><br/>";
        return str;
    }

    @DbRead
    public SuppressionState computeSuppressionState(Long idUtilisateur, ParametresArchivageDTO param) {
        try {
            String str;
            List<PeriodeCotisationUtilisateurDTO> ps;
            int nb;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            SuppressionState res = new SuppressionState();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            if (u.etatUtilisateur != EtatUtilisateur.INACTIF) {
                res.nonSupprimables.add("Cet utilisateur est \u00e0 l'\u00e9tat " + (Object)((Object)u.etatUtilisateur));
            }
            if ((nb = new UtilisateurService().countContrat(idUtilisateur)) > 0) {
                res.nonSupprimables.add("Il existe " + nb + " contrats pour cet utilisateur");
            }
            if ((ps = new GestionCotisationService().getPeriodeCotisation(idUtilisateur)).size() > 0) {
                res.nonSupprimables.add("Cet utilisateur est indiqu\u00e9 comme cotisant sur les p\u00e9riodes de cotisation suivantes :" + CollectionUtils.asStdString(ps, e -> e.periodeNom));
            }
            if ((str = new AccessManagementService().canBeDeleted(idUtilisateur)) != null) {
                res.nonSupprimables.add(str);
            }
            if ((str = this.checkPermanenceFuture(em, idUtilisateur)) != null) {
                res.reserveMajeures.add(str);
            }
            if ((str = this.checkDateCreation(em, u, 90)) != null) {
                res.reserveMajeures.add(str);
            }
            SuppressionState suppressionState = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return suppressionState;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String checkPermanenceFuture(RdbLink em, Long idUtilisateur) {
        em.createQuery("select max(d.periodePermanenceDate.datePerm) from PermanenceCell d WHERE d.periodePermanenceUtilisateur.utilisateur.id=:id");
        em.setParameter("id", idUtilisateur);
        Date dernierePermance = em.result().single(Date.class);
        if (dernierePermance != null && dernierePermance.after(DateUtils.getDateWithNoTime())) {
            return "Cet utilisateur est indiqu\u00e9  de permanence le " + FormatUtils.getStdDate().format(dernierePermance);
        }
        return null;
    }

    private String checkDateCreation(RdbLink em, Utilisateur u, int delai) {
        Date ref2 = DateUtils.getDateWithNoTime();
        if (u.dateCreation.after(ref2 = DateUtils.addDays(ref2, -delai))) {
            return "La cr\u00e9ation de cet utilisateur est trop r\u00e9cente : " + FormatUtils.getStdDate().format(u.dateCreation);
        }
        return null;
    }

    public List<UtilisateurDTO> getAllUtilisateurSupprimables(ParametresArchivageDTO param) {
        List<UtilisateurDTO> ps = new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.INACTIF);
        ArrayList<UtilisateurDTO> res = new ArrayList<UtilisateurDTO>();
        for (UtilisateurDTO p : ps) {
            SuppressionState state = this.computeSuppressionState(p.id, param);
            if (state.getStatus() != SuppressionState.SStatus.OUI_SANS_RESERVE) continue;
            res.add(p);
        }
        res.sort(Comparator.comparing(e -> e.dateCreation));
        return res;
    }
}

