/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.DocEngagementSigne;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.mescontrats.ContratStatusService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.util.ArrayList;
import java.util.List;

public class DocEngagementSignOnLineService {
    @DbRead
    public List<DocEngagementSignOnLineDTO> getAllContratASignerByAmapien(Long idUser) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select c from Contrat c where c.utilisateur.id = :idUser  AND c.modeleContrat.gestionDocEngagement=:g  AND c.docEngagementSigne is NULL  ORDER BY c.modeleContrat.nom");
            em.setParameter("idUser", idUser);
            em.setParameter("g", (Object)GestionDocEngagement.SIGNATURE_EN_LIGNE);
            List<DocEngagementSignOnLineDTO> list = em.result().listConverted(Contrat.class, e -> this.createDto(em, (Contrat)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<DocEngagementSignOnLineDTO> getAllDocumentsASignerByProducteur(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            em.createQuery("select c from Contrat c where c.modeleContrat=:mc and c.docEngagementSigne IS NOT NULL AND c.docEngagementSigne.producteurDateSignature is NULL order by c.utilisateur.nom,c.utilisateur.prenom");
            em.setParameter("mc", mc);
            List<DocEngagementSignOnLineDTO> list = em.result().listConverted(Contrat.class, e -> this.createDto(em, (Contrat)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private DocEngagementSignOnLineDTO createDto(RdbLink em, Contrat c) {
        DocEngagementSignOnLineDTO dto = new DocEngagementSignOnLineDTO();
        dto.nomModeleContrat = c.modeleContrat.nom;
        dto.nomUtilisateur = c.utilisateur.nom;
        dto.prenomUtilisateur = c.utilisateur.prenom;
        dto.idUtilisateur = c.utilisateur.getId();
        dto.idContrat = c.id;
        dto.idModeleContrat = c.modeleContrat.getId();
        DocEngagementSigne ds = c.docEngagementSigne;
        dto.signedByAmapien = ds == null ? null : ds.amapienDateSignature;
        dto.signedByProducteur = ds == null ? null : ds.producteurDateSignature;
        return dto;
    }

    @DbRead
    public List<DocEngagementSignOnLineDTO> getBilanSignature(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            if (mc.gestionDocEngagement != GestionDocEngagement.SIGNATURE_EN_LIGNE) {
                throw new AmapjRuntimeException();
            }
            em.createQuery("select c from Contrat c where c.modeleContrat=:mc order by c.utilisateur.nom,c.utilisateur.prenom");
            em.setParameter("mc", mc);
            List<DocEngagementSignOnLineDTO> list = em.result().listConverted(Contrat.class, e -> this.createDto(em, (Contrat)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public String deleteAllDocEngagement(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            em.createQuery("select c from Contrat c where c.modeleContrat.id=:id and c.docEngagementSigne IS NOT NULL");
            em.setParameter("id", modeleContrat.id);
            List<Contrat> cs = em.result().list(Contrat.class);
            ArrayList<Utilisateur> us = new ArrayList<Utilisateur>();
            for (Contrat c : cs) {
                new CoreDocEngagementSignOnLineService().deleteDocEngagementSigne(em, c);
                us.add(c.utilisateur);
            }
            String string = UtilisateurUtil.getUtilisateurImpactes(us);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public boolean producteurIsNotAllowedToSignNow(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            boolean bl = mc.nature == NatureContrat.ABONNEMENT || mc.nature == NatureContrat.LIBRE ? new ContratStatusService().isInscriptionNonTerminee(mc, DateUtils.getDate()) : false;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

