/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline.avenant;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.common.velocity.VelocityVar;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AvenantHtmlGenerator {
    private VelocityTools vt;
    private List<VelocityVar> modified1Vars;
    private Date dateModifContrat;
    public List<DocPart> docParts = new ArrayList<DocPart>();
    public DocPart current;

    public String createAvenantAsHtml(VelocityTools vt, List<VelocityVar> modified1Vars, Date dateModifContrat) {
        this.vt = vt;
        this.modified1Vars = modified1Vars;
        this.dateModifContrat = dateModifContrat;
        this.createProcessor();
        return this.process();
    }

    private String process() {
        StringBuilder sb = new StringBuilder();
        for (DocPart docPart : this.docParts) {
            sb.append(this.process(docPart));
        }
        if (sb.length() == 0) {
            throw new AmapjRuntimeException();
        }
        String top = "<!DOCTYPE html>\r\n<html>\r\n<head><meta charset=\"utf-8\">\r\n<title></title>\r\n</head>\r\n<body style=\"width:538pt;margin-right:28pt;margin-left:28pt;font-family:sans-serif;font-size:10pt;\">";
        String intro = "<br/><p style=\"text-align:center\"><span style=\"font-size:14pt\">AVENANT<strong></strong></span></p><br/><p>Ce contrat a \u00e9t\u00e9 modifi\u00e9 le " + FormatUtils.getTimeStd().format(this.dateModifContrat) + "." + "Vous trouverez ci dessous les \u00e9lements modifi\u00e9s.</p>" + "<br/>";
        String bottom = "<br/><p><strong>Nota :</strong>Un \u00e9lement est affich\u00e9 dans l'avenant si (1) il est pr\u00e9sent dans le document initial et (2) sa valeur actuelle est diff\u00e9rente de la valeur affich\u00e9e dans le document sign\u00e9 par l'amapien.Dans l'avenant, les valeurs affich\u00e9es sont les valeurs actuelles.</p></body></html>";
        String html = String.valueOf(top) + intro + this.vt.evaluate(sb.toString()) + bottom;
        return html;
    }

    private String process(DocPart docPart) {
        StringBuilder s = new StringBuilder();
        for (LinePart linePart : docPart.lines) {
            s.append(this.process(linePart));
        }
        if (s.length() == 0) {
            return "";
        }
        return "<p><strong>" + docPart.title + "</strong></p><br/>" + s + "<br/><br/>";
    }

    private String process(LinePart linePart) {
        if (!this.isModified(linePart.varName)) {
            return "";
        }
        if (linePart.prefix == null && linePart.suffix == null) {
            return "<div>$" + linePart.varName + "</div>";
        }
        StringBuilder s = new StringBuilder();
        s.append("<p>");
        if (linePart.prefix != null) {
            s.append(linePart.prefix);
            s.append(" ");
        }
        s.append("$" + linePart.varName);
        if (linePart.suffix != null) {
            s.append(linePart.suffix);
            s.append(" ");
        }
        s.append("</p>");
        return s.toString();
    }

    public void createProcessor() {
        this.addTitle("Les quantit\u00e9s command\u00e9es");
        this.add("montantProduit", "Montant total des produits : ", " \u20ac");
        this.add("amapienNbLivraison", "Nombre de livraison pour ce contrat :");
        this.add("amapienNbProduit", "Nombre de produits pour ce contrat :");
        this.add("tableauDateProduit");
        this.add("tableauDateProduitCompact");
        this.add("listeDateProduit");
        this.add("listeDateProduitCompact");
        this.add("tableauOrListeDateProduit");
        this.addTitle("Les informations de paiement");
        this.add("libCheque", "Libell\u00e9 des ch\u00e8ques : ");
        this.add("nbCheque", "Nombre des ch\u00e8ques : ");
        this.add("montantCheque", "Montant total des ch\u00e8ques : ");
        this.add("montantAvoir", "Montant de l'avoir initial : ");
        this.add("tableauDateCheque");
        this.add("listeDateCheque");
        this.add("listeDateChequeCompact");
        this.addTitle("Les reports ou jokers");
        this.add("jokerNbMax", "Nombre de jokers max");
        this.add("jokerNbMin", "Nombre de jokers min");
        this.add("jokerTxt", "Les r\u00e9gles de gestion des jokers : ");
    }

    private boolean isModified(String varName) {
        return this.modified1Vars.stream().anyMatch(e -> e.varName.equals(varName));
    }

    private void addTitle(String title) {
        this.current = new DocPart();
        this.current.title = title;
        this.docParts.add(this.current);
    }

    private void add(String varName, String prefix, String suffix) {
        LinePart l = new LinePart();
        l.varName = "contrat." + varName;
        l.prefix = prefix;
        l.suffix = suffix;
        this.current.lines.add(l);
    }

    private void add(String varName, String prefix) {
        this.add(varName, prefix, null);
    }

    private void add(String varName) {
        this.add(varName, null, null);
    }

    public static class DocPart {
        String title;
        List<LinePart> lines = new ArrayList<LinePart>();
    }

    public static class LinePart {
        String varName;
        String prefix;
        String suffix;
    }
}

