/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline.core;

import com.lowagie.text.pdf.PdfReader;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.engine.pdftools.PdfTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;

public class DocEngagementSignOnLineTools {
    public static final char CHAR_SIGNATURE_AMAPIEN = '\u0142';
    public static final char CHAR_SIGNATURE_PRODUCTEUR = '\u0140';

    public byte[] addSignatureAmapien(byte[] pdfIn, Date amapienDateSignature, String amapienLibSignature) {
        return this.addSignature('\u0142', pdfIn, amapienDateSignature, amapienLibSignature);
    }

    public byte[] addSignatureProducteur(byte[] signatureContratContent, Date producteurDateSignature, String producteurLibSignature) {
        return this.addSignature('\u0140', signatureContratContent, producteurDateSignature, producteurLibSignature);
    }

    private byte[] addSignature(char specialCharSignatureLocation, byte[] pdfIn, Date amapienDateSignature, String amapienLibSignature) {
        try {
            PdfReader reader = new PdfReader(pdfIn);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfTools.Location l = new PdfTools().findLocation(specialCharSignatureLocation, reader);
            if (l == null) {
                throw new AmapjRuntimeException("Le document ne contient pas les champs  $contrat.signatureAmapien et $contrat.signatureProducteur qui permettent de poser la signature sur le contrat");
            }
            new PdfTools().addTextToPdf(reader, baos, l, "Sign\u00e9 electroniquement", "le " + FormatUtils.getTimeStd().format(amapienDateSignature), "par " + amapienLibSignature);
            reader.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public boolean hasSignatureAmapienAndProducteur(byte[] pdfIn) {
        try {
            PdfReader reader = new PdfReader(pdfIn);
            PdfTools.Location l1 = new PdfTools().findLocation('\u0142', reader);
            PdfTools.Location l2 = new PdfTools().findLocation('\u0140', reader);
            reader.close();
            return l1 != null && l2 != null;
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public byte[] concateTwoPdf(byte[] src, int nbPage, byte[] toAdd) {
        try {
            PdfReader pdfSrc = new PdfReader(src);
            PdfReader pdfToAdd = new PdfReader(toAdd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new PdfTools().concateTwoPdf(pdfSrc, nbPage, pdfToAdd, baos);
            pdfSrc.close();
            pdfToAdd.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public byte[] getFirstPages(byte[] src, int nbPage) {
        try {
            PdfReader pdfSrc = new PdfReader(src);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new PdfTools().concateTwoPdf(pdfSrc, nbPage, null, baos);
            pdfSrc.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }
}

