/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline.model;

import com.google.gson.Gson;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.docengagement.signonline.model.DocEngagementData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DocEngagementBin {
    public byte[] pdfContent;
    public DocEngagementData docEngagementData;

    public byte[] toBytes() {
        try {
            byte[] docEngagementDataJson = new Gson().toJson((Object)this.docEngagementData).getBytes("UTF-8");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(1);
            baos.write(0);
            this.writeInt(baos, this.pdfContent.length);
            this.writeInt(baos, docEngagementDataJson.length);
            baos.write(this.pdfContent);
            baos.write(docEngagementDataJson);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public void fromBytes(byte[] bs) {
        try {
            byte version = bs[0];
            if (version != 1) {
                throw new AmapjRuntimeException("Version incorrecte : " + version);
            }
            int lenPdf = this.readInt(bs, 2);
            int lenJson = this.readInt(bs, 6);
            this.pdfContent = Arrays.copyOfRange(bs, 10, 10 + lenPdf);
            String json = new String(bs, 10 + lenPdf, lenJson, "UTF-8");
            this.docEngagementData = (DocEngagementData)new Gson().fromJson(json, DocEngagementData.class);
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    private int readInt(byte[] bs, int startIndex) {
        return ByteBuffer.wrap(bs, startIndex, 4).getInt();
    }

    private void writeInt(ByteArrayOutputStream baos, int a) throws IOException {
        baos.write(ByteBuffer.allocate(4).putInt(a).array());
    }
}

