/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import java.io.IOException;
import java.util.List;

public class EGAvoirs
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGAvoirs(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<ContratSigneDTO> avoirs = new GestionContratSigneService().getAvoirsInfo(em, this.modeleContratId);
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        et.addSheet("Avoirs", 3, 20);
        et.addRow("Liste des avoirs initiaux", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nom du contrat : " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Nom du producteur : " + mc.producteur.nom, et.grasGaucheNonWrappe);
        et.addRow(String.valueOf(avoirs.size()) + " adh\u00e9rents poss\u00e8dent un avoir", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setCell(2, "Montant avoir", et.grasCentreBordure);
        for (ContratSigneDTO contratSigneDTO : avoirs) {
            this.addRow(contratSigneDTO, et);
        }
        et.addRow("", et.grasGaucheNonWrappe);
        this.addRowCumul(et, avoirs.size());
    }

    private void addRow(ContratSigneDTO contratSigneDTO, ExcelGeneratorTool et) {
        et.addRow();
        et.setCell(0, contratSigneDTO.nomUtilisateur, et.grasGaucheNonWrappeBordure);
        et.setCell(1, contratSigneDTO.prenomUtilisateur, et.nonGrasGaucheBordure);
        et.setCellPrix(2, contratSigneDTO.mntAvoirInitial, et.prixCentreBordure);
    }

    private void addRowCumul(ExcelGeneratorTool et, int nbPaiements) {
        et.addRow();
        et.setCell(0, "Total", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColUp(2, 2, nbPaiements, et.prixCentreBordure);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "avoirs-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "la liste des avoirs initiaux du contrat";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGAvoirs(12652L).test();
    }
}

