/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;

public class EGBilanCompletCheque
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGBilanCompletCheque(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        SimpleDateFormat df = FormatUtils.getLiteralMonthDate();
        ContratDTO contratDTO = new MesContratsService().loadContrat(mc.getId(), null);
        int numColFirstMonth = 12;
        int nbMois = contratDTO.paiement.datePaiements.size();
        int nbCol = numColFirstMonth + 3 * nbMois;
        et.addSheet("Amap", nbCol, 11);
        et.setColumnWidth(0, 14);
        et.setColumnWidth(1, 12);
        et.setColumnWidth(2, 12);
        et.addRow("Bilan des ch\u00e8ques", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nom du contrat : " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Nom du producteur : " + mc.producteur.nom, et.grasGaucheNonWrappe);
        et.addRow("Ordre des ch\u00e8ques : " + mc.libCheque, et.grasGaucheNonWrappe);
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        et.addRow(String.valueOf(utilisateurs.size()) + " adh\u00e9rents pour ce contrat", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setCell(2, "Montant command\u00e9", et.grasCentreBordure);
        et.addComment(2, "Somme du montant de tous les produits command\u00e9s par l'amapien", 2);
        et.setCell(4, "Ch\u00e8ques", et.grasCentreBordure);
        et.mergeCellsRight(4, 3);
        et.setCell(8, "Solde final", et.grasCentreBordure);
        et.addComment(8, "Est \u00e9gal \u00e0 montant command\u00e9 - montant chez le producteur - montant de l'avoir", 2);
        et.setCell(9, "Ecart saisie ch\u00e8ques", et.grasCentreBordure);
        et.addComment(9, "diff\u00e9rence entre le montant command\u00e9 et les ch\u00e8ques pr\u00e9vus (quelque soit leur \u00e9tat). Un \u00e9cart appara\u00eet quand le contrat a \u00e9t\u00e9 modifi\u00e9 par le r\u00e9f\u00e9rent, par exemple quand il modifie les quantit\u00e9s sans modifier les ch\u00e8ques. L'\u00e9cart doit \u00eatre corrig\u00e9 manuellement par le r\u00e9f\u00e9rent en corrigeant les ch\u00e8ques.", 6);
        et.setCell(11, "Avoir initial", et.grasCentreBordure);
        int i = 0;
        while (i < nbMois) {
            Date d = contratDTO.paiement.datePaiements.get((int)i).datePaiement;
            String libMois = df.format(d);
            int numCol = numColFirstMonth + i * 3;
            et.setCell(numCol, libMois, et.switchColor(et.grasCentreBordure, i));
            et.mergeCellsRight(numCol, 3);
            ++i;
        }
        et.addRow();
        et.setRowHeigth(2);
        et.setCell(4, "A fournir \u00e0 l'AMAP", et.grasCentreBordure);
        et.addComment(4, "Ch\u00e8ques que les amapiens doivent donner \u00e0 l'AMAP", 2);
        et.setCell(5, "A l'AMAP", et.grasCentreBordure);
        et.addComment(5, "Ch\u00e8ques qui ont \u00e9t\u00e9 donn\u00e9s \u00e0 l'AMAP, et le r\u00e9f\u00e9rent a marqu\u00e9 ces ch\u00e8ques comme r\u00e9ceptionn\u00e9s", 2);
        et.setCell(6, "Chez le producteur", et.grasCentreBordure);
        et.addComment(6, "Ch\u00e8ques qui ont \u00e9t\u00e9 remis au producteur", 2);
        i = 0;
        while (i < nbMois) {
            CellStyle st = et.switchColor(et.grasCentreBordure, i);
            et.setCell(numColFirstMonth + i * 3, "A fournir \u00e0 l'AMAP", st);
            et.setCell(numColFirstMonth + i * 3 + 1, "A l'AMAP", st);
            et.setCell(numColFirstMonth + i * 3 + 2, "Chez le producteur", st);
            ++i;
        }
        et.mergeCellsUp(0, 2);
        et.mergeCellsUp(1, 2);
        et.mergeCellsUp(2, 2);
        et.mergeCellsUp(8, 2);
        et.mergeCellsUp(9, 2);
        et.mergeCellsUp(11, 2);
        et.addRow("", et.grasGaucheNonWrappe);
        this.addRowCumul(et, nbMois, utilisateurs, numColFirstMonth);
        et.addRow("", et.grasGaucheNonWrappe);
        for (Utilisateur utilisateur : utilisateurs) {
            this.addRow(utilisateur, et, mc, em, nbMois, numColFirstMonth);
        }
    }

    private void addRowCumul(ExcelGeneratorTool et, int nbMois, List<Utilisateur> utilisateurs, int numColFirstMonth) {
        et.addRow();
        int nbUser = utilisateurs.size();
        et.setCell(0, "Cumul", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColDown(2, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(4, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(5, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(6, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(8, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(9, 2, nbUser, et.prixCentreBordure);
        et.setCellSumInColDown(11, 2, nbUser, et.prixCentreBordure);
        int i = 0;
        while (i < nbMois) {
            CellStyle st = et.switchColor(et.prixCentreBordure, i);
            et.setCellSumInColDown(numColFirstMonth + i * 3, 2, nbUser, st);
            et.setCellSumInColDown(numColFirstMonth + i * 3 + 1, 2, nbUser, st);
            et.setCellSumInColDown(numColFirstMonth + i * 3 + 2, 2, nbUser, st);
            ++i;
        }
    }

    private void addRow(Utilisateur utilisateur, ExcelGeneratorTool et, ModeleContrat mc, RdbLink em, int nbMois, int numColFirstMonth) {
        Contrat c = new MesContratsService().getContrat(mc.getId(), em, utilisateur);
        ContratDTO contratDTO = new MesContratsService().loadContrat(mc.getId(), c.getId());
        int montantDu = new GestionContratSigneService().getMontant(em, c);
        et.addRow();
        et.setCell(0, utilisateur.nom, et.grasGaucheNonWrappeBordure);
        et.setCell(1, utilisateur.prenom, et.nonGrasGaucheBordure);
        et.setCellPrix(2, montantDu, et.prixCentreBordure);
        et.setCellSumInRow(4, numColFirstMonth, 3, nbMois, null, et.prixCentreBordureNoZero);
        et.setCellSumInRow(5, numColFirstMonth + 1, 3, nbMois, null, et.prixCentreBordureNoZero);
        et.setCellSumInRow(6, numColFirstMonth + 2, 3, nbMois, null, et.prixCentreBordureNoZero);
        et.setCellBasicFormulaInRow(8, new int[]{6, 11}, new int[]{2}, et.prixCentreBordure);
        et.setCellBasicFormulaInRow(9, new int[]{4, 5, 6, 11}, new int[]{2}, et.prixCentreBordureNoZero);
        et.setCellPrix(11, contratDTO.paiement.avoirInitial, et.prixCentreBordure);
        int i = 0;
        while (i < nbMois) {
            DatePaiementDTO dateDto = contratDTO.paiement.datePaiements.get(i);
            CellStyle st = et.switchColor(et.prixCentreBordureNoZero, i);
            et.setCellPrix(numColFirstMonth + i * 3, this.getPromis(dateDto), st);
            et.setCellPrix(numColFirstMonth + i * 3 + 1, this.getRecu(dateDto), st);
            et.setCellPrix(numColFirstMonth + i * 3 + 2, this.getRemis(dateDto), st);
            ++i;
        }
    }

    private int getPromis(DatePaiementDTO dateDto) {
        return dateDto.etatPaiement == EtatPaiement.A_FOURNIR ? dateDto.montant : 0;
    }

    private int getRecu(DatePaiementDTO dateDto) {
        return dateDto.etatPaiement == EtatPaiement.AMAP ? dateDto.montant : 0;
    }

    private int getRemis(DatePaiementDTO dateDto) {
        return dateDto.etatPaiement == EtatPaiement.PRODUCTEUR ? dateDto.montant : 0;
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "bilan-cheque-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "le bilan complet ch\u00e8ques";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

