/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.mespaiements.DetailPaiementAFournirDTO;
import fr.amapj.service.services.mespaiements.MesPaiementsService;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.persistence.Query;

public class EGCollecteCheque
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGCollecteCheque(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        et.addSheet("Amap", 1, 100);
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        et.addRow("Bordereau de collecte des ch\u00e8ques", et.titre);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nom du contrat : " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Nom du producteur : " + mc.producteur.nom, et.grasGaucheNonWrappe);
        et.addRow("Date limite de remise des ch\u00e8ques : " + df.format(mc.dateRemiseCheque), et.grasGaucheNonWrappe);
        et.addRow("Ordre des ch\u00e8ques : " + mc.libCheque, et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        et.addRow(String.valueOf(utilisateurs.size()) + " adh\u00e9rents pour ce contrat", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        for (Utilisateur utilisateur : utilisateurs) {
            et.addRow(String.valueOf(utilisateur.prenom) + " " + utilisateur.nom, et.grasGaucheNonWrappe);
            Contrat c = this.getContrat(this.modeleContratId, em, utilisateur);
            List<DetailPaiementAFournirDTO> details = new MesPaiementsService().getPaiementAFournir(em, c);
            for (DetailPaiementAFournirDTO detail : details) {
                String text = detail.formatPaiement();
                et.addRow(text, et.nongrasGaucheWrappe);
            }
            et.addRow("", et.nongrasGaucheWrappe);
        }
    }

    private Contrat getContrat(Long modeleContratId, RdbLink em, Utilisateur utilisateur) {
        ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
        Query q = em.createQuery("select c from Contrat c where c.utilisateur =:u and c.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        q.setParameter("u", (Object)utilisateur);
        List cs = q.getResultList();
        if (cs.size() != 1) {
            throw new RuntimeException("Erreur inattendue pour " + utilisateur.nom + utilisateur.prenom);
        }
        return (Contrat)cs.get(0);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "collecte-cheque-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "la feuille de collecte des cheques";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

