/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.PEReceptionCheque;
import fr.amapj.model.models.remise.RemiseProducteur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.remiseproducteur.PaiementRemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import fr.amapj.view.engine.menu.MenuList;
import java.io.IOException;

public class EGRemise
extends AbstractExcelGenerator {
    Long remiseId;

    public EGRemise(Long remiseId) {
        this.remiseId = remiseId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        RemiseProducteur remise = em.find(RemiseProducteur.class, this.remiseId);
        ModeleContrat mc = remise.datePaiement.modeleContrat;
        RemiseDTO dto = new RemiseProducteurService().loadRemise(this.remiseId);
        PEReceptionCheque peConf = (PEReceptionCheque)new ParametresService().loadParamEcran(MenuList.RECEPTION_CHEQUES);
        et.addSheet(dto.moisRemise, 7, 20);
        et.addRow("Remise de ch\u00e8ques du " + dto.moisRemise, et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nom du contrat : " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Nom du producteur : " + mc.producteur.nom, et.grasGaucheNonWrappe);
        et.addRow("Ordre des ch\u00e8ques : " + mc.libCheque, et.grasGaucheNonWrappe);
        et.addRow(String.valueOf(dto.paiements.size()) + " ch\u00e8ques dans cette remise", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setCell(2, "Montant ch\u00e8ques", et.grasCentreBordure);
        this.addTitreCommentaire(et, 3, peConf.saisieCommentaire1, peConf.libSaisieCommentaire1);
        this.addTitreCommentaire(et, 4, peConf.saisieCommentaire2, peConf.libSaisieCommentaire2);
        this.addTitreCommentaire(et, 5, peConf.saisieCommentaire3, peConf.libSaisieCommentaire3);
        this.addTitreCommentaire(et, 6, peConf.saisieCommentaire4, peConf.libSaisieCommentaire4);
        for (PaiementRemiseDTO paiementRemiseDTO : dto.paiements) {
            this.addRow(paiementRemiseDTO, et, peConf);
        }
        et.addRow("", et.grasGaucheNonWrappe);
        this.addRowCumul(et, dto.paiements.size());
    }

    private void addTitreCommentaire(ExcelGeneratorTool et, int col, ChoixOuiNon saisieCommentaire, String libSaisieCommentaire) {
        et.setCell(col, "", et.grasCentreBordure);
        if (saisieCommentaire == ChoixOuiNon.OUI) {
            et.setCell(col, libSaisieCommentaire, et.grasCentreBordure);
        } else {
            et.setColumnWidth(col, 0);
        }
    }

    private void addRow(PaiementRemiseDTO paiementRemiseDTO, ExcelGeneratorTool et, PEReceptionCheque peConf) {
        et.addRow();
        et.setCell(0, paiementRemiseDTO.nomUtilisateur, et.grasGaucheNonWrappeBordure);
        et.setCell(1, paiementRemiseDTO.prenomUtilisateur, et.nonGrasGaucheBordure);
        et.setCellPrix(2, paiementRemiseDTO.montant, et.prixCentreBordure);
        this.addCellCommentaire(et, 3, peConf.saisieCommentaire1, paiementRemiseDTO.commentaire1);
        this.addCellCommentaire(et, 4, peConf.saisieCommentaire2, paiementRemiseDTO.commentaire2);
        this.addCellCommentaire(et, 5, peConf.saisieCommentaire3, paiementRemiseDTO.commentaire3);
        this.addCellCommentaire(et, 6, peConf.saisieCommentaire4, paiementRemiseDTO.commentaire4);
    }

    private void addCellCommentaire(ExcelGeneratorTool et, int col, ChoixOuiNon saisieCommentaire, String commentaire) {
        et.setCell(col, "", et.grasCentreBordure);
        if (saisieCommentaire == ChoixOuiNon.OUI) {
            et.setCell(col, commentaire, et.nonGrasGaucheBordure);
        }
    }

    private void addRowCumul(ExcelGeneratorTool et, int nbPaiements) {
        et.addRow();
        et.setCell(0, "Total", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColUp(2, 2, nbPaiements, et.prixCentreBordure);
    }

    @Override
    public String getFileName(RdbLink em) {
        RemiseProducteur remise = em.find(RemiseProducteur.class, this.remiseId);
        ModeleContrat mc = remise.datePaiement.modeleContrat;
        return "remise-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "la feuille de remise des ch\u00e8ques au producteur";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGRemise(12652L).test();
    }
}

