/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.amapien;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.edgenerator.excel.cheque.EGSyntheseCheque;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGFeuilleDistributionAmapien;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class EGBilanCompletAmapien
extends AbstractExcelGenerator {
    Long idUtilisateur;

    public EGBilanCompletAmapien(Long idUtilisateur) {
        this.idUtilisateur = idUtilisateur;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
        TypedQuery<Contrat> q = em.createQuery("select c from Contrat c where c.utilisateur =:u order by c.dateCreation", Contrat.class);
        q.setParameter("u", (Object)u);
        List cs = q.getResultList();
        this.addInfoGenerale(em, et, u, cs);
        this.addInfoCotisations(em, et, u);
        this.addListeContrats(em, u, et, cs);
        new EGSyntheseCheque(EGSyntheseCheque.Mode.TOUS, this.idUtilisateur).addOneSheet(em, u, et, "Ch\u00e8ques", false);
        this.addInfoPermanence(em, et, u);
        this.addLivraison(em, et, cs);
    }

    private void addInfoGenerale(RdbLink em, ExcelGeneratorTool et, Utilisateur u, List<Contrat> cs) {
        et.addSheet("Generalites", 2, 70);
        et.addRow("Informations g\u00e9n\u00e9rales pour l'utilisateur " + u.nom + " " + u.prenom, et.grasGaucheNonWrappe);
        et.addRow();
        this.addLine(et, "Nom", u.nom);
        this.addLine(et, "Pr\u00e9nom", u.prenom);
        this.addLine(et, "E mail", u.email);
        this.addLine(et, "T\u00e9l\u00e9phone 1", u.numTel1);
        this.addLine(et, "T\u00e9l\u00e9phone 2", u.numTel2);
        this.addLine(et, "Adresse", u.libAdr1);
        this.addLine(et, "Code postal", u.codePostal);
        this.addLine(et, "Ville", u.ville);
        et.addRow();
        this.addLine(et, "Date de cr\u00e9ation : ", u.dateCreation);
        this.addLine(et, "Nombre de contrats de cet utilisateur : ", "" + cs.size());
        et.addRow();
        List<String> roles = new AccessManagementService().detailDesRoles(u.id);
        for (String role : roles) {
            this.addLine(et, role, "");
        }
    }

    private void addLine(ExcelGeneratorTool et, String col1, String col2) {
        et.addRow();
        et.setCell(0, col1, et.grasGaucheNonWrappe);
        et.setCell(1, col2, et.nonGrasGaucheNonWrappe);
    }

    private void addLine(ExcelGeneratorTool et, String col1, Date col2) {
        et.addRow();
        et.setCell(0, col1, et.grasGaucheNonWrappe);
        et.setCellDate(1, col2, et.nonGrasGaucheNonWrappe);
    }

    private void addInfoCotisations(RdbLink em, ExcelGeneratorTool et, Utilisateur u) {
        List<PeriodeCotisationUtilisateurDTO> ps = new GestionCotisationService().getPeriodeCotisation(u.id);
        et.addSheet("Cotisations", 8, 20);
        et.addRow("Liste des cotisations pour l'utilisateur " + u.nom + " " + u.prenom, et.grasGaucheNonWrappe);
        et.addRow();
        if (ps.size() == 0) {
            et.addRow("Cet utilisateur n'est pas associ\u00e9 \u00e0 une p\u00e9riode de cotisation", et.grasGaucheNonWrappe);
            return;
        }
        et.addRow();
        et.setCell(0, "Nom p\u00e9riode", et.grasCentreBordure);
        et.setCell(1, "Date de d\u00e9but", et.grasCentreBordure);
        et.setCell(2, "Date de fin", et.grasCentreBordure);
        et.setCell(3, "Date de l'adhesion", et.grasCentreBordure);
        et.setCell(4, "Montant de l'adhesion", et.grasCentreBordure);
        et.setCell(5, "R\u00e9ception paiement", et.grasCentreBordure);
        et.setCell(6, "Etat du paiement", et.grasCentreBordure);
        et.setCell(7, "Type du paiement", et.grasCentreBordure);
        for (PeriodeCotisationUtilisateurDTO p : ps) {
            et.addRow();
            et.setCell(0, p.periodeNom, et.nonGrasGaucheBordure);
            et.setCellDate(1, p.periodeDateDebut, et.nonGrasCentreBordure);
            et.setCellDate(2, p.periodeDateFin, et.nonGrasCentreBordure);
            et.setCellDate(3, p.dateAdhesion, et.nonGrasCentreBordure);
            et.setCellPrix(4, p.montantAdhesion, et.prixCentreBordure);
            et.setCellDate(5, p.dateReceptionCheque, et.nonGrasCentreBordure);
            et.setCell(6, "" + (Object)((Object)p.etatPaiementAdhesion), et.nonGrasCentreBordure);
            et.setCell(7, "" + (Object)((Object)p.typePaiementAdhesion), et.nonGrasCentreBordure);
        }
    }

    private void addListeContrats(RdbLink em, Utilisateur u, ExcelGeneratorTool et, List<Contrat> cs) {
        et.addSheet("Liste des contrats", 7, 50);
        et.setColumnWidth(0, 15);
        et.setColumnWidth(1, 25);
        et.setColumnWidth(4, 20);
        et.setColumnWidth(5, 15);
        et.setColumnWidth(6, 15);
        et.addRow("Liste des contrats pour l'utilisateur " + u.nom + " " + u.prenom, et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Num\u00e9ro", et.grasCentreBordure);
        et.setCell(1, "Date de cr\u00e9ation", et.grasCentreBordure);
        et.setCell(2, "Nom du contrat", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Nom du producteur", et.grasGaucheNonWrappeBordure);
        et.setCell(4, "Montant", et.grasCentreBordure);
        et.setCell(5, "Date de d\u00e9but", et.grasCentreBordure);
        et.setCell(6, "Date de fin", et.grasCentreBordure);
        int i = 0;
        while (i < cs.size()) {
            Contrat contrat = cs.get(i);
            ContratSigneDTO dto = new GestionContratSigneService().createContratSigneInfo(em, contrat);
            ModeleContratSummaryDTO mcDto = new GestionContratService().createModeleContratInfo(em, contrat.modeleContrat);
            et.addRow();
            et.setCell(0, "C" + (i + 1), et.nonGrasCentreBordure);
            et.setCellDateTime(1, contrat.dateCreation, et.nonGrasCentreBordure);
            et.setCell(2, contrat.modeleContrat.nom, et.nonGrasGaucheBordure);
            et.setCell(3, contrat.modeleContrat.producteur.nom, et.nonGrasGaucheBordure);
            et.setCellPrix(4, dto.mntCommande, et.prixCentreBordure);
            et.setCellDate(5, mcDto.dateDebut, et.nonGrasCentreBordure);
            et.setCellDate(6, mcDto.dateFin, et.nonGrasCentreBordure);
            ++i;
        }
    }

    private void addInfoPermanence(RdbLink em, ExcelGeneratorTool et, Utilisateur u) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        List<PeriodePermanenceDTO> ps = new PeriodePermanenceService().getAllPermanenceDTO(u.id);
        CollectionUtils.sort(ps, e -> e.dateDebut);
        et.addSheet("Permanences", 2, 70);
        et.addRow("Liste des permanences pour l'utilisateur " + u.nom + " " + u.prenom, et.grasGaucheNonWrappe);
        et.addRow();
        for (PeriodePermanenceDTO p : ps) {
            PeriodePermanenceUtilisateurDTO ppu = p.findPeriodePermanenceUtilisateurDTO(u.id);
            List<PeriodePermanenceDateDTO> dates = p.findPeriodePermanenceDateDTO(u.id);
            et.addRow();
            this.addLine(et, "Nom de la p\u00e9riode de permanence", p.nom);
            this.addLine(et, "Date de d\u00e9but", p.dateDebut);
            this.addLine(et, "Date de fin", p.dateFin);
            this.addLine(et, "Nombre de participations demand\u00e9es", "" + ppu.nbParticipation);
            this.addLine(et, "Nombre de dates o\u00f9 l'utilisateur s'est inscrit", "" + dates.size());
            int i = 0;
            while (i < dates.size()) {
                PeriodePermanenceDateDTO date = dates.get(i);
                String str = "Inscrit pour le " + df.format(date.datePerm) + " avec le(s) role(s) " + CollectionUtils.asString(date.getRoles(u.id), ",");
                this.addLine(et, "Date " + (i + 1), str);
                ++i;
            }
            et.addRow();
        }
    }

    private void addLivraison(RdbLink em, ExcelGeneratorTool et, List<Contrat> cs) {
        int i = 0;
        while (i < cs.size()) {
            Contrat contrat = cs.get(i);
            String nomPage = "C" + (i + 1);
            new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.STD, contrat.modeleContrat.id, contrat.id).addOnePage(em, et, nomPage);
            ++i;
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
        return "bilan-complet-amapien-" + u.nom + " " + u.prenom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
        return "Le bilan complet pour l'amapien " + u.nom + " " + u.prenom;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

