/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.emargement;

import fr.amapj.common.LongUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.editionspe.emargement.ContenuCellule;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.editionspe.emargement.ParametresProduitsJson;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargement;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;

public class EGFeuilleEmargementGrille {
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et, FeuilleEmargementJson planningJson, EGFeuilleEmargement.LibInfo libInfo) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM");
        Entete entete = this.getEntetePlanning(em, planningJson, libInfo);
        List<Utilisateur> utilisateurs = this.getUtilisateur(em, libInfo, planningJson);
        int nbCol = entete.prodCols.size() + 5;
        et.addSheet("Feuille \u00e9margement " + libInfo.lib2 + " " + libInfo.lib1, nbCol, 25);
        et.setMarginAndPageFormat(planningJson);
        et.addRow();
        et.setCell(0, "DISTRIBUTIONS " + libInfo.lib1.toUpperCase(), et.grasCentreBordure);
        et.mergeCellsRight(0, 2);
        int index = 2;
        for (DateColonne dateCol : entete.dateCols) {
            et.setCell(index, df.format(dateCol.date), et.grasCentreBordure);
            et.mergeCellsRight(index, dateCol.nbColProduit);
            index += dateCol.nbColProduit;
        }
        et.setCell(index, "T\u00e9l\u00e9phone 1 ", et.grasCentreBordure);
        et.setCell(++index, "T\u00e9l\u00e9phone 2 ", et.grasCentreBordure);
        et.setCell(++index, "Commentaire ", et.grasCentreBordure);
        et.addRow();
        et.setRowHeigth(3);
        et.setCell(1, "Responsable de distribution", et.nongrasGaucheWrappe);
        index = 2;
        for (DateColonne dateCol : entete.dateCols) {
            et.setCell(index, dateCol.permanence, et.nonGrasCentreBordure);
            et.mergeCellsRight(index, dateCol.nbColProduit);
            index += dateCol.nbColProduit;
        }
        et.setCell(index, "", et.grasCentreBordure);
        et.setCell(++index, "", et.grasCentreBordure);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setColumnWidthInMm(0, planningJson.getLgColNom());
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setColumnWidthInMm(1, planningJson.getLgColPrenom());
        index = 2;
        for (ProduitColonne prodCol : entete.prodCols) {
            if (prodCol.idProduit != null) {
                et.setCell(index, prodCol.nomColonne, et.grasCentreBordure);
                et.setColumnWidthInMm(index, prodCol.largeurColonne);
            } else {
                et.setCell(index, prodCol.nomColonne, et.grasCentreBordureColorPetit);
                et.setColumnWidthInMm(index, planningJson.getLgColPresence());
            }
            ++index;
        }
        et.setCell(index, "", et.grasCentreBordure);
        et.mergeCellsUp(index, 3);
        et.setColumnWidthInMm(index, planningJson.getLgColnumTel1());
        et.setCell(++index, "", et.grasCentreBordure);
        et.mergeCellsUp(index, 3);
        et.setColumnWidthInMm(index, planningJson.getLgColnumTel2());
        et.setCell(++index, "", et.grasCentreBordure);
        et.mergeCellsUp(index, 3);
        et.setColumnWidthInMm(index, planningJson.getLgColCommentaire());
        et.setRepeatingRow(1, 3);
        int numLigne = 0;
        for (Utilisateur utilisateur : utilisateurs) {
            this.addRowUtilisateur(et, utilisateur, em, entete, numLigne, libInfo, planningJson.getContenuCellule(), planningJson.getHauteurLigne());
            ++numLigne;
        }
    }

    private void addRowUtilisateur(ExcelGeneratorTool et, Utilisateur utilisateur, RdbLink em, Entete entete, int numLigne, EGFeuilleEmargement.LibInfo libInfo, ContenuCellule contenuCellule, int hauteurLigne) {
        int[] qtes = this.getQte(utilisateur, em, entete.prodCols, libInfo);
        et.addRow();
        if (hauteurLigne > 0) {
            et.setRowHeigthInMm(hauteurLigne);
        }
        et.setCell(0, utilisateur.nom, et.switchGray(et.grasGaucheWrappeBordure, numLigne));
        et.setCell(1, utilisateur.prenom, et.switchGray(et.nonGrasGaucheBordure, numLigne));
        int index = 2;
        int i = 0;
        while (i < qtes.length) {
            ProduitColonne prodCol = entete.prodCols.get(i);
            if (prodCol.idProduit != null) {
                if (contenuCellule == ContenuCellule.QUANTITE) {
                    et.setCellQte(index, qtes[i], et.switchGray(et.grasCentreBordure, numLigne));
                } else {
                    String str = qtes[i] > 0 ? "X" : " ";
                    et.setCell(index, str, et.switchGray(et.grasCentreBordure, numLigne));
                }
            } else {
                et.setCell(index, "", et.grasCentreBordureColor);
            }
            ++index;
            ++i;
        }
        et.setCell(index, utilisateur.numTel1, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, utilisateur.numTel2, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, "", et.switchGray(et.nonGrasCentreBordure, numLigne));
    }

    private int[] getQte(Utilisateur u, RdbLink em, List<ProduitColonne> prodCols, EGFeuilleEmargement.LibInfo libInfo) {
        Query q = em.createQuery("select c from ContratCell c WHERE  c.modeleContratDate.dateLiv >= :d1 AND c.modeleContratDate.dateLiv<:d2 AND c.contrat.utilisateur=:u");
        q.setParameter("d1", (Object)libInfo.debut);
        q.setParameter("d2", (Object)libInfo.fin);
        q.setParameter("u", (Object)u);
        int[] res = new int[prodCols.size()];
        List ccs = q.getResultList();
        for (ContratCell cc : ccs) {
            int index = this.findIndex(prodCols, cc);
            if (index == -1) continue;
            res[index] = res[index] + cc.qte;
        }
        return res;
    }

    private int findIndex(List<ProduitColonne> prodCols, ContratCell cc) {
        int s = prodCols.size();
        int i = 0;
        while (i < s) {
            ProduitColonne produitColonne = prodCols.get(i);
            if (produitColonne.idProduit != null && produitColonne.idProduit.contains(cc.modeleContratProduit.produit.getId()) && cc.modeleContratDate.dateLiv.equals(produitColonne.dateColonne.date)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<Utilisateur> getUtilisateur(RdbLink em, EGFeuilleEmargement.LibInfo libInfo, FeuilleEmargementJson planningJson) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ParametresProduitsJson pp : planningJson.getParametresProduits()) {
            ids.add(pp.getIdProduit());
        }
        Query q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c WHERE  c.modeleContratDate.dateLiv >= :d1 AND c.modeleContratDate.dateLiv<:d2 AND c.modeleContratProduit.produit.id IN :ids  ORDER BY c.contrat.utilisateur.nom , c.contrat.utilisateur.prenom");
        q.setParameter("d1", (Object)libInfo.debut);
        q.setParameter("d2", (Object)libInfo.fin);
        q.setParameter("ids", ids);
        List us = q.getResultList();
        return us;
    }

    private Entete getEntetePlanning(RdbLink em, FeuilleEmargementJson planningJson, EGFeuilleEmargement.LibInfo libInfo) {
        Entete entete = new Entete();
        List<PeriodePermanenceDateDTO> permanenceDTOs = this.getPermanence(em, libInfo);
        List<Date> dateLivs = this.getDateLivs(em, libInfo);
        for (Date dateLiv : dateLivs) {
            this.findProduits(em, entete, dateLiv, planningJson, permanenceDTOs);
        }
        return entete;
    }

    private List<PeriodePermanenceDateDTO> getPermanence(RdbLink em, EGFeuilleEmargement.LibInfo libInfo) {
        return new PeriodePermanenceService().getAllDistributionsActif(em, libInfo.debut, libInfo.fin);
    }

    private List<Date> getDateLivs(RdbLink em, EGFeuilleEmargement.LibInfo libInfo) {
        Query q = em.createQuery("select distinct(mcd.dateLiv) from ModeleContratDate mcd WHERE mcd.dateLiv >= :d1 AND mcd.dateLiv<:d2 ORDER BY mcd.dateLiv");
        q.setParameter("d1", (Object)libInfo.debut);
        q.setParameter("d2", (Object)libInfo.fin);
        List us = q.getResultList();
        return us;
    }

    private void findProduits(RdbLink em, Entete entete, Date dateLiv, FeuilleEmargementJson planningJson, List<PeriodePermanenceDateDTO> permanenceDTOs) {
        List<ProduitColonne> cols = this.computeProdCol(em, dateLiv, planningJson);
        if (cols.size() == 0) {
            return;
        }
        ProduitColonne prodCol = new ProduitColonne();
        prodCol.nomColonne = "Pr\u00e9sence";
        cols.add(prodCol);
        DateColonne dateCol = new DateColonne();
        dateCol.date = dateLiv;
        dateCol.nbColProduit = cols.size();
        dateCol.permanence = this.findPermanence(permanenceDTOs, dateLiv);
        for (ProduitColonne produitColonne : cols) {
            produitColonne.dateColonne = dateCol;
        }
        entete.prodCols.addAll(cols);
        entete.dateCols.add(dateCol);
    }

    private List<ProduitColonne> computeProdCol(RdbLink em, Date dateLiv, FeuilleEmargementJson planningJson) {
        ArrayList<ProduitColonne> res = new ArrayList<ProduitColonne>();
        ProduitColonne previous = null;
        for (ParametresProduitsJson prodJson : planningJson.getParametresProduits()) {
            Produit p = em.find(Produit.class, prodJson.getIdProduit());
            ProduitColonne prodCol = this.constructProdCol(em, p, dateLiv, prodJson, previous);
            if (prodCol == null) continue;
            previous = prodCol;
            res.add(prodCol);
        }
        return res;
    }

    private ProduitColonne constructProdCol(RdbLink em, Produit p, Date dateLiv, ParametresProduitsJson prodJson, ProduitColonne previous) {
        Query q = em.createQuery("select count(c) from ContratCell c WHERE  c.modeleContratProduit.produit=:p AND  c.modeleContratDate.dateLiv=:d ");
        q.setParameter("p", (Object)p);
        q.setParameter("d", (Object)dateLiv);
        if (LongUtils.toInt(q.getSingleResult()) == 0) {
            return null;
        }
        if (previous != null && StringUtils.equals(previous.nomColonne, prodJson.getTitreColonne())) {
            previous.idProduit.add(p.getId());
            return null;
        }
        ProduitColonne prodCol = new ProduitColonne();
        prodCol.idProduit = new ArrayList<Long>();
        prodCol.idProduit.add(p.getId());
        prodCol.largeurColonne = prodJson.getLargeurColonne();
        prodCol.nomColonne = prodJson.getTitreColonne();
        return prodCol;
    }

    private String findPermanence(List<PeriodePermanenceDateDTO> permanenceDTOs, Date dateLiv) {
        for (PeriodePermanenceDateDTO permanenceDTO : permanenceDTOs) {
            if (!permanenceDTO.datePerm.equals(dateLiv)) continue;
            return permanenceDTO.getNomInscrit("\n");
        }
        return "";
    }

    public static class DateColonne {
        public Date date;
        public int nbColProduit;
        public String permanence;
    }

    public static class Entete {
        public List<ProduitColonne> prodCols = new ArrayList<ProduitColonne>();
        public List<DateColonne> dateCols = new ArrayList<DateColonne>();
    }

    public static class ProduitColonne {
        public String nomColonne;
        public int largeurColonne;
        public List<Long> idProduit;
        public DateColonne dateColonne;
    }
}

