/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGGrilleTool;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;

public class EGFeuilleDistributionAmapien
extends AbstractExcelGenerator {
    private Long contratId;
    private Long modeleContratId;
    private EGMode mode;

    public EGFeuilleDistributionAmapien(EGMode mode, Long modeleContratId, Long contratId) {
        this.mode = mode;
        this.modeleContratId = modeleContratId;
        this.contratId = contratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        this.addOnePage(em, et, "AMAP");
    }

    public void addOnePage(RdbLink em, ExcelGeneratorTool et, String nomPage) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        List<ModeleContratProduit> prods = new GestionContratService().getAllProduit(em, mc);
        ContratDTO contratDTO = new MesContratsService().loadContrat(mc.getId(), this.contratId);
        List<ContratLigDTO> dates = contratDTO.contratLigs;
        int nbColGauche = 3;
        int nbColTotal = nbColGauche + prods.size();
        et.addSheet(nomPage, nbColTotal, 10);
        et.setColumnWidth(0, 20);
        et.setColumnWidth(1, 2);
        ArrayList<String> titres = new ArrayList<String>();
        titres.add("");
        String firstLine = "Feuille de distribution amapien de ";
        if (this.mode == EGMode.STD) {
            Utilisateur u = em.find(Contrat.class, (Object)this.contratId).utilisateur;
            firstLine = String.valueOf(firstLine) + u.prenom + " " + u.nom;
        }
        int nbLine = dates.size();
        new EGGrilleTool().contructEntete(et, mc, firstLine, titres, prods, nbLine, nbColGauche, "Dates", "");
        SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy");
        int i = 0;
        while (i < dates.size()) {
            this.contructRow(et, contratDTO, nbColGauche, i, dates.get((int)i).date, df2, prods.size());
            ++i;
        }
        if (this.mode == EGMode.UN_VIERGE && contratDTO.hasOneOrMoreExcluded() && nbColTotal >= 4) {
            et.addRow();
            et.addRow();
            et.setCell(0, "", et.grasGaucheNonWrappe);
            et.setCell(1, "", et.grasGaucheNonWrappe);
            et.setCell(2, "", et.nonGrasCentreBordureDiagonal);
            et.setCell(3, "produit non disponible", et.grasGaucheNonWrappe);
        }
    }

    private void contructRow(ExcelGeneratorTool et, ContratDTO contratDto, int nbColGauche, int dateIndex, Date date, SimpleDateFormat df2, int nbProd) {
        et.addRow();
        et.setCell(0, df2.format(date), et.grasCentreBordure);
        et.setCell(1, "", et.grasGaucheNonWrappeBordure);
        et.setCellSumProdInRow(2, 3, nbProd, 7, et.prixCentreBordure);
        int index = nbColGauche;
        int j = 0;
        while (j < contratDto.contratColumns.size()) {
            CellStyle style = et.nonGrasCentreBordure;
            if (contratDto.isExcluded(dateIndex, j)) {
                style = et.nonGrasCentreBordureDiagonal;
            }
            et.setCellQte(index, contratDto.cell[dateIndex][j].qte, style);
            ++index;
            ++j;
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        String str = "distri-amapien-" + mc.nom;
        if (this.mode == EGMode.UN_VIERGE) {
            return String.valueOf(str) + "-vierge";
        }
        Utilisateur u = em.find(Contrat.class, (Object)this.contratId).utilisateur;
        return String.valueOf(str) + "-" + u.nom + " " + u.prenom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        String str = "la feuille de distribution amapien " + mc.nom;
        if (this.mode == EGMode.UN_VIERGE) {
            return String.valueOf(str) + " vierge";
        }
        Utilisateur u = em.find(Contrat.class, (Object)this.contratId).utilisateur;
        return String.valueOf(str) + " pour " + u.nom + " " + u.prenom;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGFeuilleDistributionAmapien(EGMode.STD, null, null).test();
    }

    public static enum EGMode {
        STD,
        UN_VIERGE;

    }
}

