/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGFeuilleDistributionAmapien;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.persistence.Query;

public class EGLiasseFeuilleDistributionAmapien
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGLiasseFeuilleDistributionAmapien(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        List<Contrat> contrats = this.getContrat(em, mc);
        for (Contrat contrat : contrats) {
            Utilisateur u = contrat.utilisateur;
            new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.STD, this.modeleContratId, contrat.getId()).addOnePage(em, et, String.valueOf(u.nom) + " " + u.prenom);
        }
        if (contrats.size() == 0) {
            et.addSheet("CONTRATS", 1, 20);
            SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            et.addRow("AUCUN CONTRAT SIGNE !!!", et.grasGaucheNonWrappe);
            et.addRow(mc.nom, et.grasGaucheNonWrappe);
            et.addRow(mc.description, et.grasGaucheNonWrappe);
            et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        }
    }

    private List<Contrat> getContrat(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select c from Contrat c WHERE c.modeleContrat=:mc order by c.utilisateur.nom, c.utilisateur.prenom");
        q.setParameter("mc", (Object)mc);
        List cs = q.getResultList();
        return cs;
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "distri-amapien-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        em.find(ModeleContrat.class, this.modeleContratId);
        return "toutes les feuilles de distribution amapien";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGLiasseFeuilleDistributionAmapien(8342L).test();
    }
}

