/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur;

import fr.amapj.common.CollectionUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.etiquette.EtiquetteProducteurJson;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.editionspe.EditionSpeService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.apache.poi.ss.usermodel.CellStyle;

public class EGEtiquetteDistribution {
    private Long modeleContratDateId;

    public EGEtiquetteDistribution(Long modeleContratDateId) {
        this.modeleContratDateId = modeleContratDateId;
    }

    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM yyyy");
        SimpleDateFormat df2 = new SimpleDateFormat("dd MMMMM");
        ModeleContratDate mcd = em.find(ModeleContratDate.class, this.modeleContratDateId);
        EditionSpecifique editionSpe = mcd.modeleContrat.producteur.etiquette;
        EtiquetteProducteurJson etiquette = (EtiquetteProducteurJson)new EditionSpeService().load(editionSpe.id);
        List<ContratCellNumber> cells = this.getContratCell(em);
        int nbCol = etiquette.getNbColonne();
        et.addSheet(String.valueOf(df2.format(mcd.dateLiv)) + "-Etiquettes", nbCol, 10);
        int i = 0;
        while (i < nbCol) {
            et.setColumnWidthInMm(i, etiquette.getLargeurColonnes().get(i).getLargeur());
            ++i;
        }
        et.setMargin(etiquette.getMargeGauche(), etiquette.getMargeDroite(), etiquette.getMargeHaut(), etiquette.getMargeBas());
        List<List<ContratCellNumber>> lines = CollectionUtils.cutInSubList(cells, nbCol);
        for (List<ContratCellNumber> line : lines) {
            this.processOneLine(line, et, df, etiquette);
        }
    }

    private List<ContratCellNumber> getContratCell(RdbLink em) {
        ModeleContratDate mcDate = em.find(ModeleContratDate.class, this.modeleContratDateId);
        Query q = em.createQuery("select c from ContratCell c WHERE c.modeleContratDate=:mcDate order by c.contrat.utilisateur.nom , c.contrat.utilisateur.prenom");
        q.setParameter("mcDate", (Object)mcDate);
        ArrayList<ContratCellNumber> ret = new ArrayList<ContratCellNumber>();
        List cells = q.getResultList();
        for (ContratCell cell : cells) {
            int qte = cell.qte;
            int i = 1;
            while (i <= qte) {
                ContratCellNumber ccn = new ContratCellNumber();
                ccn.cell = cell;
                ccn.number = i++;
                ccn.totalNumber = qte;
                ret.add(ccn);
            }
        }
        return ret;
    }

    private void processOneLine(List<ContratCellNumber> line, ExcelGeneratorTool et, SimpleDateFormat df, EtiquetteProducteurJson etiquette) {
        et.addRow();
        et.setRowHeigthInMm(etiquette.getHauteur());
        int index = 0;
        for (ContratCellNumber cell : line) {
            String content = this.getContent(cell, df);
            CellStyle style = et.grasCentreBordure;
            if (etiquette.getBordure() == ChoixOuiNon.NON) {
                style = et.grasCentre;
            }
            et.setCell(index, content, style);
            ++index;
        }
    }

    private String getContent(ContratCellNumber ccn, SimpleDateFormat df) {
        ContratCell cell = ccn.cell;
        String str = String.valueOf(df.format(cell.modeleContratDate.dateLiv)) + "\n";
        Utilisateur u = cell.contrat.utilisateur;
        str = String.valueOf(str) + u.nom + " " + u.prenom + "\n";
        Produit p = cell.modeleContratProduit.produit;
        str = String.valueOf(str) + p.nom + "," + p.conditionnement + "\n";
        str = String.valueOf(str) + ccn.number + " / " + ccn.totalNumber + "\n";
        return str;
    }

    private static class ContratCellNumber {
        public ContratCell cell;
        public int number;
        public int totalNumber;

        private ContratCellNumber() {
        }
    }
}

