/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.EGTotalLivraisonGrille;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGEtiquetteDistribution;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGFeuilleDistributionProducteurListe;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGGrilleTool;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EGFeuilleDistributionProducteur
extends AbstractExcelGenerator {
    Long modeleContratId;
    Long modeleContratDateId;

    public EGFeuilleDistributionProducteur(Long modeleContratId, Long modeleContratDateId) {
        this.modeleContratId = modeleContratId;
        this.modeleContratDateId = modeleContratDateId;
    }

    public EGFeuilleDistributionProducteur(Long modeleContratId) {
        this(modeleContratId, null);
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        EGGrilleTool grilleTool = new EGGrilleTool();
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        List<ModeleContratProduit> prods = new GestionContratService().getAllProduit(em, mc);
        List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        Map<Utilisateur, ContratDTO> contrats = grilleTool.loadContrat(em, utilisateurs, mc);
        int nbColGauche = 3;
        Producteur p = mc.producteur;
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM");
        SimpleDateFormat df3 = new SimpleDateFormat("dd MMMMM yyyy");
        for (ModeleContratDate date : dates) {
            if (!this.isAccordingDate(date, this.modeleContratDateId)) continue;
            if (p.feuilleDistributionGrille == ChoixOuiNon.OUI) {
                this.addSheetGrilleMode(date, df3, df, et, mc, prods, utilisateurs, nbColGauche, contrats, grilleTool);
            }
            if (p.feuilleDistributionListe == ChoixOuiNon.OUI) {
                new EGFeuilleDistributionProducteurListe(date.getId()).fillExcelFile(em, et);
            }
            if (!new EditionSpeService().needEtiquette(this.modeleContratId)) continue;
            new EGEtiquetteDistribution(date.getId()).fillExcelFile(em, et);
        }
        if (this.modeleContratDateId == null && p.feuilleDistributionGrille == ChoixOuiNon.OUI) {
            new EGTotalLivraisonGrille().fillExcelFile(em, et, prods, dates, mc);
        }
    }

    private void addSheetGrilleMode(ModeleContratDate date, SimpleDateFormat df3, SimpleDateFormat df, ExcelGeneratorTool et, ModeleContrat mc, List<ModeleContratProduit> prods, List<Utilisateur> utilisateurs, int nbColGauche, Map<Utilisateur, ContratDTO> contrats, EGGrilleTool grilleTool) {
        ArrayList<ModeleContratDate> ds = new ArrayList<ModeleContratDate>();
        ds.add(date);
        ParametresDTO param = new ParametresService().getParametres();
        String firstLine = String.valueOf(param.nomAmap) + " - Feuille de distribution producteur du " + df3.format(date.dateLiv);
        String sheetName = df.format(date.dateLiv);
        grilleTool.performSheet(et, firstLine, sheetName, mc, prods, ds, utilisateurs, nbColGauche, contrats);
        et.setColHidden(2, true);
        et.adjustSheetForOnePage();
        et.setRepeatingRow(6, 9);
    }

    private boolean isAccordingDate(ModeleContratDate date, Long modeleContratDateId) {
        if (modeleContratDateId == null) {
            return true;
        }
        return date.getId().equals(modeleContratDateId);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        if (this.modeleContratDateId == null) {
            return "distri-" + mc.nom;
        }
        ModeleContratDate date = em.find(ModeleContratDate.class, this.modeleContratDateId);
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        return "distri-" + mc.nom + "-" + df.format(date.dateLiv);
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        if (this.modeleContratDateId == null) {
            return "toutes les feuilles de distribution producteur";
        }
        ModeleContratDate date = em.find(ModeleContratDate.class, this.modeleContratDateId);
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM yyyy");
        return "la feuille de distribution producteur du " + df.format(date.dateLiv);
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGFeuilleDistributionProducteur(4342L).test();
    }
}

