/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.TypedQuery;
import org.apache.poi.ss.usermodel.CellStyle;

public class EGGrilleTool {
    public void performSheet(ExcelGeneratorTool et, String firstLine, String nomFeuille, ModeleContrat mc, List<ModeleContratProduit> prods, List<ModeleContratDate> dates, List<Utilisateur> utilisateurs, int nbColGauche, Map<Utilisateur, ContratDTO> contrats) {
        int nbColDateProd = dates.size() * prods.size();
        int nbColTotal = nbColGauche + nbColDateProd;
        et.addSheet(nomFeuille, nbColTotal, 10);
        et.setColumnWidth(0, 16);
        et.setColumnWidth(1, 16);
        SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy");
        ArrayList<String> titres = new ArrayList<String>();
        for (ModeleContratDate date : dates) {
            titres.add(df2.format(date.dateLiv));
        }
        this.contructEntete(et, mc, firstLine, titres, prods, utilisateurs.size(), nbColGauche, "Nom", "Pr\u00e9nom");
        int i = 0;
        while (i < utilisateurs.size()) {
            Utilisateur utilisateur = utilisateurs.get(i);
            ContratDTO contratDto = contrats.get(utilisateur);
            this.contructRow(et, contratDto, utilisateur, nbColDateProd, nbColGauche, dates);
            ++i;
        }
    }

    public void contructEntete(ExcelGeneratorTool et, ModeleContrat mc, String firstLine, List<String> titres, List<ModeleContratProduit> prods, int nbClient, int nbColGauche, String c1, String c2) {
        int index;
        SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        et.addRow(firstLine, et.grasGaucheNonWrappe);
        et.addRow(mc.nom, et.grasGaucheNonWrappe);
        et.addRow(mc.description, et.grasGaucheNonWrappe);
        et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, c1, et.grasCentreBordure);
        et.setCell(1, c2, et.grasCentreBordure);
        et.setCell(2, "Montant total", et.grasCentreBordure);
        int i = 0;
        while (i < titres.size()) {
            String titre = titres.get(i);
            int index2 = nbColGauche + i * prods.size();
            et.setCell(index2, titre, et.switchColor(et.grasCentreBordure, i));
            et.mergeCellsRight(index2, prods.size());
            ++i;
        }
        et.addRow();
        et.setRowHeigth(4);
        i = 0;
        int k = 0;
        while (k < titres.size()) {
            for (ModeleContratProduit prod : prods) {
                index = nbColGauche + i;
                et.setCell(index, prod.produit.nom, et.switchColor(et.grasCentreBordure, k));
                ++i;
            }
            ++k;
        }
        et.addRow();
        i = 0;
        k = 0;
        while (k < titres.size()) {
            for (ModeleContratProduit prod : prods) {
                index = nbColGauche + i;
                et.setCellPrix(index, prod.prix, et.switchColor(et.prixCentreBordure, k));
                ++i;
            }
            ++k;
        }
        et.addRow();
        et.setRowHeigth(6);
        et.mergeCellsUp(0, 4);
        et.mergeCellsUp(1, 4);
        et.mergeCellsUp(2, 4);
        i = 0;
        k = 0;
        while (k < titres.size()) {
            for (ModeleContratProduit prod : prods) {
                index = nbColGauche + i;
                et.setCell(index, prod.produit.conditionnement, et.switchColor(et.grasCentreBordure, k));
                ++i;
            }
            ++k;
        }
        et.addRow();
        et.addRow();
        et.setCell(0, "Cumul", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.grasGaucheNonWrappeBordure);
        et.setCellSumInColDown(2, 2, nbClient, et.prixCentreBordure);
        i = 0;
        k = 0;
        while (k < titres.size()) {
            Iterator<ModeleContratProduit> iterator = prods.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int index3 = nbColGauche + i;
                et.setCellSumInColDown(index3, 2, nbClient, et.switchColor(et.grasCentreBordure, k));
                ++i;
            }
            ++k;
        }
        et.addRow();
    }

    private void contructRow(ExcelGeneratorTool et, ContratDTO contratDto, Utilisateur utilisateur, int nbColDateProd, int nbColGauche, List<ModeleContratDate> dates) {
        et.addRow();
        et.setCell(0, utilisateur.nom, et.grasGaucheNonWrappeBordure);
        et.setCell(1, utilisateur.prenom, et.nonGrasGaucheBordure);
        et.setCellSumProdInRow(2, 3, nbColDateProd, 7, et.prixCentreBordure);
        int index = nbColGauche;
        int k = 0;
        while (k < dates.size()) {
            ModeleContratDate date = dates.get(k);
            int i = this.findIndex(date, contratDto.contratLigs);
            int j = 0;
            while (j < contratDto.contratColumns.size()) {
                CellStyle style = et.nonGrasCentreBordure;
                if (contratDto.isExcluded(i, j)) {
                    style = et.nonGrasCentreBordureDiagonal;
                }
                et.setCellQte(index, contratDto.cell[i][j].qte, et.switchColor(style, k));
                ++index;
                ++j;
            }
            ++k;
        }
    }

    private int findIndex(ModeleContratDate date, List<ContratLigDTO> contratLigs) {
        int i = 0;
        while (i < contratLigs.size()) {
            ContratLigDTO contratLigDTO = contratLigs.get(i);
            if (contratLigDTO.modeleContratDateId.equals(date.getId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ContratDTO findContrat(RdbLink em, Utilisateur utilisateur, ModeleContrat mc) {
        TypedQuery<Contrat> query = em.createQuery("select c from Contrat c where c.modeleContrat=:mc and c.utilisateur=:u", Contrat.class);
        query.setParameter("mc", (Object)mc);
        query.setParameter("u", (Object)utilisateur);
        List contrats = query.getResultList();
        if (contrats.size() == 0) {
            throw new RuntimeException("Erreur inattendue");
        }
        if (contrats.size() > 1) {
            throw new RuntimeException("L'utilisateur " + utilisateur.nom + " poss\u00e9de plusieurs contrats !!");
        }
        Contrat contrat = (Contrat)contrats.get(0);
        return new MesContratsService().loadContrat(contrat.modeleContrat.getId(), contrat.getId());
    }

    public Map<Utilisateur, ContratDTO> loadContrat(RdbLink em, List<Utilisateur> utilisateurs, ModeleContrat mc) {
        HashMap<Utilisateur, ContratDTO> res = new HashMap<Utilisateur, ContratDTO>();
        for (Utilisateur utilisateur : utilisateurs) {
            ContratDTO dto = this.findContrat(em, utilisateur, mc);
            res.put(utilisateur, dto);
        }
        return res;
    }
}

