/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.livraison;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.common.collections.M2;
import fr.amapj.common.periode.PeriodeUtils;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.service.services.meslivraisons.MesLivraisonsService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class LivraisonAmapienCommon {
    public List<M2.Pair<Date, List<ContratCell>, List<PeriodePermanenceDate>>> computeListDateLiv(RdbLink em, Utilisateur u, Date startDate, Date endDate) {
        List<ContratCell> cells = this.getContratCell(em, u, startDate, endDate);
        G1D<Date, ContratCell> c1 = new G1D<Date, ContratCell>();
        c1.fill(cells);
        c1.groupBy(e -> e.modeleContratDate.dateLiv);
        c1.compute();
        List dateLivs = c1.getFullCells();
        List<PeriodePermanenceDate> perms = new MesLivraisonsService().getAllDistributionsForUtilisateur(em, startDate, endDate, u);
        G1D<Date, PeriodePermanenceDate> c2 = new G1D<Date, PeriodePermanenceDate>();
        c2.fill(perms);
        c2.groupBy(e -> e.datePerm);
        c2.compute();
        List datePerms = c2.getFullCells();
        return M2.merge(dateLivs, e -> (Date)e.lig, e -> e.values, e -> new ArrayList(), datePerms, e -> (Date)e.lig, e -> e.values, e -> new ArrayList()).get();
    }

    public String getDescriptionPeriode(TypPeriode typPeriode, Date startDate, Date endDate) {
        return PeriodeUtils.getDescriptionPeriode(typPeriode, startDate, endDate);
    }

    public String getDescriptionPeriodeTitre(TypPeriode typPeriode, Date startDate, Date endDate) {
        switch (typPeriode) {
            case JOUR: {
                SimpleDateFormat df = FormatUtils.getFullDate();
                return ("DE LA JOURNEE DU " + df.format(startDate)).toUpperCase();
            }
            case SEMAINE: {
                SimpleDateFormat df = FormatUtils.getFullDate();
                return ("DE LA SEMAINE DU " + df.format(startDate) + " AU " + df.format(endDate)).toUpperCase();
            }
            case MOIS: {
                SimpleDateFormat df = FormatUtils.getMoisFullText();
                return ("DU MOIS DE " + df.format(startDate)).toUpperCase();
            }
            case TRIMESTRE: {
                return ("DU TRIMESTRE DE " + FormatUtils.formatTrimestreFullText(startDate)).toUpperCase();
            }
            case A_PARTIR_DE: {
                SimpleDateFormat df = FormatUtils.getFullDate();
                return ("POUR TOUTES LES DATES A PARTIR DU " + df.format(startDate)).toUpperCase();
            }
        }
        throw new AmapjRuntimeException();
    }

    public List<G1D.Cell1<ModeleContrat, ContratCell>> computeBlocDate(List<ContratCell> contratCells) {
        G1D<ModeleContrat, ContratCell> c1 = new G1D<ModeleContrat, ContratCell>();
        c1.fill(contratCells);
        c1.groupBy(e -> e.modeleContratDate.modeleContrat);
        c1.sortLig(e -> e.producteur.nom, true);
        c1.sortLig(e -> e.nom, true);
        c1.sortCell(e -> e.modeleContratProduit.indx, true);
        c1.compute();
        List<G1D.Cell1<ModeleContrat, ContratCell>> livs = c1.getFullCells();
        return livs;
    }

    private List<ContratCell> getContratCell(RdbLink em, Utilisateur u, Date startDate, Date endDate) {
        String query = "select c from ContratCell c WHERE c.modeleContratDate.dateLiv >= :d1 ";
        if (endDate != null) {
            query = String.valueOf(query) + "AND c.modeleContratDate.dateLiv<=:d2 ";
        }
        query = String.valueOf(query) + " AND c.contrat.utilisateur=:u";
        TypedQuery<ContratCell> q = em.createQuery(query, ContratCell.class);
        q.setParameter("d1", (Object)startDate);
        if (endDate != null) {
            q.setParameter("d2", (Object)endDate);
        }
        q.setParameter("u", (Object)u);
        return q.getResultList();
    }

    public String getFileName(TypPeriode typPeriode, Date startDate, Date endDate) {
        switch (typPeriode) {
            case JOUR: {
                return "jour-" + FormatUtils.getDateFile().format(startDate);
            }
            case SEMAINE: {
                return "semaine-" + FormatUtils.getDateFile().format(startDate);
            }
            case MOIS: {
                return "mois-" + FormatUtils.getMoisFile().format(startDate);
            }
            case TRIMESTRE: {
                return "trimestre-" + FormatUtils.formatTrimestreFile(startDate);
            }
            case A_PARTIR_DE: {
                return "tout-" + FormatUtils.getDateFile().format(startDate);
            }
        }
        throw new AmapjRuntimeException();
    }

    public List<Utilisateur> getUtilisateurs(RdbLink em, Long idUtilisateur, Date startDate, Date endDate) {
        if (idUtilisateur != null) {
            return Arrays.asList(em.find(Utilisateur.class, idUtilisateur));
        }
        TypedQuery<Utilisateur> q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c WHERE  c.modeleContratDate.dateLiv >= :d1 AND c.modeleContratDate.dateLiv<=:d2  ORDER BY c.contrat.utilisateur.nom , c.contrat.utilisateur.prenom", Utilisateur.class);
        q.setParameter("d1", (Object)startDate);
        q.setParameter("d2", (Object)endDate);
        return q.getResultList();
    }

    public List<String> getInfoPermanence(List<PeriodePermanenceDate> perms) {
        ArrayList<String> res = new ArrayList<String>();
        for (PeriodePermanenceDate perm : perms) {
            res.add(this.getInfoPermanence(perm));
        }
        return res;
    }

    private String getInfoPermanence(PeriodePermanenceDate perm) {
        SimpleDateFormat df1 = FormatUtils.getFullDate();
        PeriodePermanenceDateDTO dateDTO = new PeriodePermanenceService().loadOneDatePermanence(perm.id);
        String msg = "!! Attention, vous devez r\u00e9aliser la permanence ce " + df1.format(dateDTO.datePerm) + " (" + perm.periodePermanence.nom + ")!! - " + "Liste des personnes de permanence : " + dateDTO.getNomInscrit();
        return msg;
    }
}

