/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.mntlivre;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.collections.G2D;
import fr.amapj.common.periode.PeriodeManager;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.mntlivre.MntLivreTools;
import java.util.List;

public class EGProducteurMntLivre
extends AbstractExcelGenerator {
    private TypPeriode typPeriode;
    private MntLivreTools tools;

    public EGProducteurMntLivre(TypPeriode typPeriode, int nbJourAvant, int nbJourApres) {
        this.tools = new MntLivreTools(typPeriode, nbJourAvant, nbJourApres);
        this.typPeriode = typPeriode;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        this.tools.fillExcelFile(em, et, periode -> this.fillTab(em, et, (PeriodeManager.Periode)periode));
    }

    private void fillTab(RdbLink em, ExcelGeneratorTool et, PeriodeManager.Periode periode) {
        String nomPeriode = periode.getLib();
        List<ContratCell> cs = this.tools.getContratCell(em, periode);
        G2D<Utilisateur, Producteur, ContratCell> c1 = new G2D<Utilisateur, Producteur, ContratCell>();
        c1.fill(cs);
        c1.groupByLig(e -> e.contrat.utilisateur);
        c1.groupByCol(e -> e.contrat.modeleContrat.producteur);
        c1.sortLig(e -> e.nom, true);
        c1.sortLig(e -> e.prenom, true);
        c1.sortCol(e -> e.nom, true);
        c1.compute();
        List<Utilisateur> ligs = c1.getLigs();
        List cols = c1.getCols();
        int nbCol = cols.size() + 2;
        et.addSheet(nomPeriode, nbCol, 25);
        et.setColumnWidth(0, 50);
        et.setColumnWidth(1, 15);
        et.addRow();
        et.setRowHeigth(2);
        et.setCell(0, "", et.grasCentreBordureGray);
        et.setCell(1, "", et.grasCentreBordureGray);
        int index = 2;
        for (Producteur u : cols) {
            et.setCell(index, u.nom, et.grasCentreBordureGray);
            ++index;
        }
        et.createFreezePane(1, 1);
        this.tools.addAllLines(ligs, nbCol, em, et, c1);
    }

    @Override
    public String getFileName(RdbLink em) {
        switch (this.typPeriode) {
            case MOIS: {
                return "mnt-livre-producteur-mois";
            }
            case JOUR: {
                return "mnt-livre-producteur-jour";
            }
        }
        throw new AmapjRuntimeException();
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        switch (this.typPeriode) {
            case MOIS: {
                return "Montant livr\u00e9 pour chaque producteur et pour chaque amapien, avec une feuille par mois";
            }
            case JOUR: {
                return "Montant livr\u00e9 pour chaque producteur et pour chaque amapien, avec une feuille par jour";
            }
        }
        throw new AmapjRuntimeException();
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

