/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.nouvelarrivant;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGFeuilleDistributionAmapien;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class EGAllContratsVierges
extends AbstractExcelGenerator {
    private EGMode egMode;

    public EGAllContratsVierges(EGMode egMode) {
        this.egMode = egMode;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        TypedQuery<ModeleContrat> q;
        if (this.egMode == EGMode.ACTIFS) {
            q = em.createQuery("select mc from ModeleContrat mc where mc.etat =:etat order by mc.producteur.nom,mc.nom", ModeleContrat.class);
            q.setParameter("etat", (Object)EtatModeleContrat.ACTIF);
        } else {
            Date ref = DateUtils.getDateWithNoTime();
            q = em.createQuery("select distinct(mcd.modeleContrat) from ModeleContratDate mcd where mcd.dateLiv>=:ref AND mcd.modeleContrat.etat =:etat order by mcd.modeleContrat.producteur.nom,mcd.modeleContrat.nom", ModeleContrat.class);
            q.setParameter("etat", (Object)EtatModeleContrat.ACTIF);
            q.setParameter("ref", (Object)ref);
        }
        List mcs = q.getResultList();
        this.addListeModeleContrats(em, et, mcs);
        int i = 0;
        while (i < mcs.size()) {
            ModeleContrat mc = (ModeleContrat)mcs.get(i);
            new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.UN_VIERGE, mc.id, null).addOnePage(em, et, "MC" + (i + 1));
            ++i;
        }
    }

    private void addListeModeleContrats(RdbLink em, ExcelGeneratorTool et, List<ModeleContrat> mcs) {
        et.addSheet("Liste", 5, 50);
        et.setColumnWidth(0, 15);
        et.setColumnWidth(1, 60);
        et.setColumnWidth(3, 15);
        et.setColumnWidth(4, 15);
        String str = this.egMode == EGMode.ACTIFS ? "Liste des mod\u00e8les de contrats actifs" : "Liste des mod\u00e8les de contrats actifs ayant au moins une livraison dans le futur";
        et.addRow(str, et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Num\u00e9ro", et.grasCentreBordure);
        et.setCell(1, "Nom du mod\u00e8le de contrat", et.grasGaucheNonWrappeBordure);
        et.setCell(2, "Nom du producteur", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Date de d\u00e9but", et.grasCentreBordure);
        et.setCell(4, "Date de fin", et.grasCentreBordure);
        int i = 0;
        while (i < mcs.size()) {
            ModeleContrat mc = mcs.get(i);
            ModeleContratSummaryDTO mcDto = new GestionContratService().createModeleContratInfo(em, mc);
            et.addRow();
            et.setCell(0, "MC" + (i + 1), et.nonGrasCentreBordure);
            et.setCell(1, mc.nom, et.nonGrasGaucheBordure);
            et.setCell(2, mc.producteur.nom, et.nonGrasGaucheBordure);
            et.setCellDate(3, mcDto.dateDebut, et.nonGrasCentreBordure);
            et.setCellDate(4, mcDto.dateFin, et.nonGrasCentreBordure);
            ++i;
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        if (this.egMode == EGMode.ACTIFS) {
            return "liasse-contrats-vierges-actifs";
        }
        return "liasse-contrats-vierges-futurs";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        if (this.egMode == EGMode.ACTIFS) {
            return "La liasse des feuilles de distribution vierges pour tous les modeles de contrats actifs";
        }
        return "La liasse des feuilles de distribution vierges pour tous les modeles de contrats actifs ayant au moins une livraison dans le futur";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static enum EGMode {
        ACTIFS,
        FUTUR;

    }
}

