/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.nouvelarrivant;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.visiteamap.VisiteAmapDTO;
import fr.amapj.service.services.visiteamap.VisiteAmapService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class EGVisiteAmap
extends AbstractExcelGenerator {
    private EGMode egMode;
    private SimpleDateFormat df1 = FormatUtils.getFullDate();
    private SimpleDateFormat df = FormatUtils.getStdDate();
    private static final char BULLET_CHARACTER = '\u2022';

    public EGVisiteAmap(EGMode egMode) {
        this.egMode = egMode;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        TypedQuery<Date> q = em.createQuery("select distinct(mcd.dateLiv) from ModeleContratDate mcd where mcd.modeleContrat.etat =:etat order by mcd.dateLiv", Date.class);
        q.setParameter("etat", (Object)EtatModeleContrat.ACTIF);
        List dateLivs = q.getResultList();
        if (dateLivs.size() == 0) {
            et.addSheet("D\u00e9couverte / Visite", 1, 50);
            et.addRow("Aucune livraison pour aucune date", et.grasGaucheNonWrappe);
            return;
        }
        Date dateDebut = (Date)dateLivs.get(0);
        Date dateFin = (Date)dateLivs.get(dateLivs.size() - 1);
        if (this.egMode == EGMode.FUTUR) {
            dateDebut = DateUtils.getDateWithNoTime();
        }
        VisiteAmapDTO dto = new VisiteAmapService().getAll(dateDebut, dateFin, null);
        if (dto.jours.size() == 0) {
            et.addSheet("D\u00e9couverte / Visite", 1, 50);
            et.addRow("Aucune livraison pour aucune date", et.grasGaucheNonWrappe);
            return;
        }
        for (VisiteAmapDTO.Jour jour : dto.jours) {
            this.addOnePage(jour, et);
        }
    }

    private void addOnePage(VisiteAmapDTO.Jour jour, ExcelGeneratorTool et) {
        et.addSheet(this.df.format(jour.dateLiv), 1, 200);
        et.addRow(this.df1.format(jour.dateLiv), et.grasGaucheNonWrappe);
        et.addRow();
        for (VisiteAmapDTO.Producteur producteur : jour.producteurs) {
            this.addBlocProducteur(producteur, et);
        }
    }

    private void addBlocProducteur(VisiteAmapDTO.Producteur producteur, ExcelGeneratorTool et) {
        for (VisiteAmapDTO.Contrat contrat : producteur.contrats) {
            this.addBlocContrat(contrat, et, producteur.producteurNom);
        }
    }

    private void addBlocContrat(VisiteAmapDTO.Contrat contrat, ExcelGeneratorTool et, String producteurNom) {
        et.addRow("Producteur : " + producteurNom + " Contrat : " + contrat.contratNom, et.grasGaucheNonWrappe);
        et.addRow();
        for (VisiteAmapDTO.LigneContrat lig : contrat.ligneContrats) {
            et.addRow(" \u2022 " + lig.produitNom + ", " + lig.produitConditionnement + " - Prix : " + FormatUtils.prix(lig.produitPrix), et.nonGrasGaucheNonWrappe);
        }
        et.addRow();
    }

    @Override
    public String getFileName(RdbLink em) {
        if (this.egMode == EGMode.ACTIFS) {
            return "d\u00e9couverte";
        }
        return "d\u00e9couverte-futur";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        if (this.egMode == EGMode.ACTIFS) {
            return "La description des produits propos\u00e9s pour toutes les dates de livraisons (pass\u00e9es ou futures)";
        }
        return "La description des produits propos\u00e9s pour toutes les dates de livraisons futures";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static enum EGMode {
        ACTIFS,
        FUTUR;

    }
}

