/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.permanence;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelCellAutoSize;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;

public class EGBilanInscriptionPermanence
extends AbstractExcelGenerator {
    private Long idPeriodePermanence;

    public EGBilanInscriptionPermanence(Long idPeriodePermanence) {
        this.idPeriodePermanence = idPeriodePermanence;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        PeriodePermanenceDTO dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(this.idPeriodePermanence);
        new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        List<UtilisateurInfo> alls = CollectionUtils.convert(dto.utilisateurs, e -> this.createUtilisateurInfo((PeriodePermanenceUtilisateurDTO)e, dto, em));
        List<UtilisateurInfo> retards = CollectionUtils.filter(alls, e -> e.nbParticipationSouhaite - e.nbParticipationRelle > 0);
        List<UtilisateurInfo> oks = CollectionUtils.filter(alls, e -> e.nbParticipationSouhaite - e.nbParticipationRelle <= 0);
        this.addSheet(retards, et, dto, "En retard", "Liste des utilisateurs en retard pour s'inscrire", true);
        this.addSheet(oks, et, dto, "Inscription ok", "Liste des utilisateurs inscrits correctement", false);
        this.addSheet(alls, et, dto, "bilan global", "Bilan global de l'inscription des utilisateurs", false);
    }

    private UtilisateurInfo createUtilisateurInfo(PeriodePermanenceUtilisateurDTO utilisateurInfo, PeriodePermanenceDTO dto, RdbLink em) {
        UtilisateurInfo ui = new UtilisateurInfo();
        ui.utilisateur = em.find(Utilisateur.class, utilisateurInfo.idUtilisateur);
        ui.nbParticipationSouhaite = utilisateurInfo.nbParticipation;
        ui.nbParticipationRelle = dto.datePerms.stream().mapToInt(e -> e.countInscrit(periodePermanenceUtilisateurDTO.idUtilisateur)).sum();
        return ui;
    }

    private void addSheet(List<UtilisateurInfo> oks, ExcelGeneratorTool et, PeriodePermanenceDTO dto, String nomFeuille, String titre, boolean displayMail) {
        SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        et.addSheet(nomFeuille, 6, 20);
        et.setColumnWidth(2, 40);
        et.setColumnWidth(3, 10);
        et.setColumnWidth(4, 10);
        et.setColumnWidth(5, 10);
        et.addRow("P\u00e9riode de permanence " + dto.nom, et.grasGaucheNonWrappe);
        et.addRow(titre, et.grasGaucheNonWrappe);
        et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Nom", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasGaucheNonWrappeBordure);
        et.setCell(2, "E mail", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Souhait\u00e9", et.grasCentreBordure);
        et.setCell(4, "R\u00e9el", et.grasCentreBordure);
        et.setCell(5, "Delta", et.grasCentreBordure);
        for (UtilisateurInfo u : oks) {
            et.addRow();
            et.setCell(0, u.utilisateur.nom, et.grasGaucheNonWrappeBordure);
            et.setCell(1, u.utilisateur.prenom, et.nonGrasGaucheBordure);
            et.setCell(2, u.utilisateur.email, et.nonGrasGaucheBordure);
            et.setCellQte(3, u.nbParticipationSouhaite, et.grasCentreBordure);
            et.setCellQte(4, u.nbParticipationRelle, et.grasCentreBordure);
            et.setCellQte(5, u.nbParticipationSouhaite - u.nbParticipationRelle, et.grasCentreBordure);
        }
        if (displayMail) {
            et.addRow();
            et.addRow("Liste des e mails des utilisateurs concern\u00e9s :", et.grasGaucheNonWrappe);
            et.addRow();
            ExcelCellAutoSize as = new ExcelCellAutoSize(5);
            UtilisateurUtil.EmailInfo email = UtilisateurUtil.getEmailsInfos(CollectionUtils.select(oks, e -> e.utilisateur));
            Row currentRow = et.addRow();
            et.setCell(0, email.utilisateurAvecEmail, et.nonGrasGaucheBordure);
            et.mergeCellsRight(0, 6);
            int size = 605;
            as.addCell(size, "Arial", 10);
            as.addLine(email.utilisateurAvecEmail);
            as.autosize(currentRow);
            if (email.nbUtilisateurSansEmail != 0) {
                et.addRow();
                et.addRow("Attention : il y a " + email.nbUtilisateurSansEmail + " utilisateurs sans e mail : ", et.grasGaucheNonWrappe);
                et.addRow();
                et.addRow();
                et.setCell(0, email.utilisateurSansEmail, et.nonGrasGaucheBordure);
                et.mergeCellsRight(0, 6);
            }
        }
        et.addRow();
        et.addRow();
        et.addRow();
        et.setCell(0, "Souhait\u00e9 : ", et.grasGaucheNonWrappe);
        et.setCell(1, "Nombre de permanence que l'amapien doit faire", et.nonGrasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "R\u00e9el : ", et.grasGaucheNonWrappe);
        et.setCell(1, "Nombre de permanence o\u00f9 l'amapien est inscrit", et.nonGrasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Delta : ", et.grasGaucheNonWrappe);
        et.setCell(1, "Souhait\u00e9 - R\u00e9el", et.nonGrasGaucheNonWrappe);
    }

    @Override
    public String getFileName(RdbLink em) {
        PeriodePermanence pp = em.find(PeriodePermanence.class, this.idPeriodePermanence);
        return "bilan-permanence-" + pp.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        PeriodePermanence pp = em.find(PeriodePermanence.class, this.idPeriodePermanence);
        return "le bilan des inscriptions \u00e0 la permanence " + pp.nom;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGBilanInscriptionPermanence(1L).test();
    }

    public static class UtilisateurInfo {
        public Utilisateur utilisateur;
        public int nbParticipationSouhaite;
        public int nbParticipationRelle;
    }
}

