/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.producteur;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.EGAvoirs;
import fr.amapj.service.services.edgenerator.excel.EGRemise;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.remiseproducteur.RemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

public class EGPaiementProducteur
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGPaiementProducteur(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        List<RemiseDTO> remises = new RemiseProducteurService().getAllRemise(this.modeleContratId);
        List<RemiseDTO> nextRemises = new RemiseProducteurService().getNextRemise(this.modeleContratId);
        int mntAvoir = new GestionContratService().getMontantAvoir(em, mc);
        this.createPageGarde(em, et, remises, nextRemises, mntAvoir, mc);
        if (mntAvoir > 0) {
            new EGAvoirs(this.modeleContratId).fillExcelFile(em, et);
        }
        for (RemiseDTO remiseDTO : remises) {
            new EGRemise(remiseDTO.id).fillExcelFile(em, et);
        }
    }

    private void createPageGarde(RdbLink em, ExcelGeneratorTool et, List<RemiseDTO> remises, List<RemiseDTO> nextRemises, int mntAvoir, ModeleContrat mc) {
        et.addSheet("Bilan paiement", 5, 18);
        et.addRow("Bilan des paiements", et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nom du contrat : " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Nom du producteur : " + mc.producteur.nom, et.grasGaucheNonWrappe);
        et.addRow("Ordre des ch\u00e8ques : " + mc.libCheque, et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setRowHeigth(2);
        et.setCell(0, "Mois", et.grasCentreBordure);
        et.setCell(1, "Date r\u00e9elle de remise", et.grasCentreBordure);
        et.setCell(2, "Montant", et.grasCentreBordure);
        et.setCell(3, "Nb de ch\u00e8ques", et.grasCentreBordure);
        et.setCell(4, "Etat de la remise", et.grasCentreBordure);
        this.addRowAvoir(et, mntAvoir);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        for (RemiseDTO remiseDTO : remises) {
            this.addRow(remiseDTO, et, df, false);
        }
        for (RemiseDTO remiseDTO : nextRemises) {
            this.addRow(remiseDTO, et, df, true);
        }
        et.addRow("", et.grasGaucheNonWrappe);
        this.addRowCumul(et, remises, nextRemises, em, mc);
    }

    private void addRowAvoir(ExcelGeneratorTool et, int mntAvoir) {
        et.addRow();
        et.setCell(0, "Avoirs initiaux", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasCentreBordure);
        et.setCellPrix(2, mntAvoir, et.prixCentreBordure);
        et.setCell(3, "", et.nonGrasCentreBordure);
        et.setCell(4, "", et.grasCentreBordure);
    }

    private void addRow(RemiseDTO remiseDTO, ExcelGeneratorTool et, SimpleDateFormat df, boolean isPrevision) {
        et.addRow();
        et.setCell(0, remiseDTO.moisRemise, et.grasGaucheNonWrappeBordure);
        String dateRemise = isPrevision ? "" : df.format(remiseDTO.dateReelleRemise);
        et.setCell(1, dateRemise, et.nonGrasCentreBordure);
        et.setCellPrix(2, remiseDTO.mnt, et.prixCentreBordure);
        int nbCheque = isPrevision ? 0 : remiseDTO.nbCheque;
        et.setCellQte(3, nbCheque, et.nonGrasCentreBordure);
        String etatRemise = isPrevision ? "PREVISION" : "FAIT";
        et.setCell(4, etatRemise, et.grasCentreBordure);
    }

    private void addRowCumul(ExcelGeneratorTool et, List<RemiseDTO> remises, List<RemiseDTO> nextRemises, RdbLink em, ModeleContrat mc) {
        et.addRow();
        et.mergeCellsRight(0, 2);
        et.setCell(0, "Total pay\u00e9 ", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColUp(2, 2 + nextRemises.size(), remises.size() + 1, et.prixCentreBordure);
        et.addRow();
        et.mergeCellsRight(0, 2);
        et.setCell(0, "Total restant \u00e0 payer ", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColUp(2, 3, nextRemises.size(), et.prixCentreBordure);
        et.addRow();
        int mntTotal = new GestionContratService().getMontantCommande(em, mc);
        et.addRow();
        et.mergeCellsRight(0, 2);
        et.setCell(0, "Montant total des produits", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellPrix(2, mntTotal, et.prixCentreBordure);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "bilan-paiement-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "le bilan des paiements d'un producteur";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGPaiementProducteur(4342L).test();
    }
}

